/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.convert.channels;

import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.SkillType;

public class SplitChannels
extends Bouncelet {
    public InAudio inAudio = new InAudio("in", "Input audio wave");
    public OutAudio outAudio0 = new OutAudio("out0", "Output of channel 0");
    public OutAudio outAudio1 = new OutAudio("out1", "Output of channel 1");
    public OutAudio outAudio2 = new OutAudio("out2", "Output of channel 2");
    public OutAudio outAudio3 = new OutAudio("out3", "Output of channel 3");
    public OutAudio outAudio4 = new OutAudio("out4", "Output of channel 4");
    public OutAudio outAudio5 = new OutAudio("out5", "Output of channel 5");
    public OutAudio outAudio6 = new OutAudio("out6", "Output of channel 6");
    public OutAudio outAudio7 = new OutAudio("out7", "Output of channel 7");
    public OutAudio outAudio8 = new OutAudio("out8", "Output of channel 8");
    public OutAudio outAudio9 = new OutAudio("out9", "Output of channel 9");
    public OutAudio[] outAudios = new OutAudio[]{this.outAudio0, this.outAudio1, this.outAudio2, this.outAudio3, this.outAudio4, this.outAudio5, this.outAudio6, this.outAudio7, this.outAudio8, this.outAudio9};

    public SplitChannels() {
        super("audio.convert.channels.splitChannels", "Split channels into mono audio waves");
        super.setSkillType(SkillType.ADVANCED);
        int i = 4;
        while (i < this.outAudios.length) {
            this.outAudios[i].setSkillType(SkillType.ADVANCED);
            ++i;
        }
    }

    @Override
    public void cycle() {
        WaveData inWave = (WaveData)this.inAudio.read();
        int c = 0;
        while (c < this.outAudios.length) {
            this.outAudios[c].prepare(1, inWave.nbFrames, inWave.windowing);
            ++c;
        }
        int chan = 0;
        while (chan < inWave.nbChannels) {
            float[] in = inWave.data[chan];
            float[] out = ((WaveData)this.outAudios[chan].get()).data[0];
            assert (in.length == out.length);
            int i = 0;
            while (i < out.length) {
                out[i] = in[i];
                ++i;
            }
            ++chan;
        }
        chan = inWave.nbChannels;
        while (chan < this.outAudios.length) {
            this.outAudios[chan].setModified(false);
            ++chan;
        }
    }
}

