/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.convert.channels;

import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;

public class ToMono
extends Bouncelet {
    public InAudio inAudio = new InAudio("in", "Input audio wave");
    public OutAudio outAudio = new OutAudio("out", "Output audio wave");

    public ToMono() {
        super("audio.convert.channels.toMono", "Mix multi-channel audio to mono");
    }

    @Override
    public void cycle() {
        WaveData inWave = (WaveData)this.inAudio.read();
        this.outAudio.prepare(1, inWave.nbFrames, inWave.windowing);
        WaveData outWave = (WaveData)this.outAudio.get();
        float correction = 1.0f / (float)inWave.nbChannels;
        int chan = 0;
        while (chan < inWave.nbChannels) {
            int i;
            float[] in = inWave.data[chan];
            float[] out = outWave.data[0];
            assert (in.length == out.length);
            if (chan == 0) {
                i = 0;
                while (i < out.length) {
                    out[i] = in[i] * correction;
                    ++i;
                }
            } else {
                i = 0;
                while (i < out.length) {
                    int n = i;
                    out[n] = out[n] + in[i] * correction;
                    ++i;
                }
            }
            ++chan;
        }
    }
}

