/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.convert.channels;

import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.ports.InInt;

public class ToMulti
extends Bouncelet {
    public InAudio inAudio = new InAudio("in", "Input mono audio wave");
    public InInt inChannels = new InInt("channels", "Number of output channels", 2, 1, 10);
    public OutAudio outAudio = new OutAudio("out", "Output multi-channel audio wave");

    public ToMulti() {
        super("audio.convert.channels.toStereo", "Convert mono audio to multi-channel audio by duplicating the single channel");
    }

    @Override
    public void cycle() {
        WaveData inWave = (WaveData)this.inAudio.read();
        int channels = (Integer)this.inChannels.read();
        this.outAudio.prepare(channels, inWave.nbFrames, inWave.windowing);
        WaveData outWave = (WaveData)this.outAudio.get();
        int chan = 0;
        while (chan < outWave.nbChannels) {
            float[] in = inWave.data[chan % inWave.nbChannels];
            float[] out = outWave.data[chan];
            assert (in.length == out.length);
            int i = 0;
            while (i < out.length) {
                out[i] = in[i];
                ++i;
            }
            ++chan;
        }
    }
}

