/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.convert.format;

import org.corebounce.common.math.Fraction;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.FlowEngine;
import org.corebounce.decklight.GraphErrorType;
import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.base.WindowFactory;
import org.corebounce.decklight.bouncelets.audio.base.WindowInfo;
import org.corebounce.decklight.bouncelets.audio.base.WindowType;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.InPowerOf2;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.utils.Severity;

public class BlockSize
extends Bouncelet {
    public InAudio inAudio = new InAudio("in", "Input Audio Wave");
    public InPowerOf2 inBlockSize = new InPowerOf2(true, "blockSize", "Block size", PowerOf2.p512);
    public OutAudio outAudio = new OutAudio("out", "Output Audio Wave");
    private WindowInfo windowing;
    private transient WaveData srcWave;
    private transient int srcOffset;
    private transient int dstOffset;
    private transient int inputSize;
    private transient int outputSize;
    private transient boolean isDirty;
    private transient boolean isWaveRead;
    private transient Fraction timeSkew;

    public BlockSize() {
        super("audio.convert.format.blocksize", "Change the size of audio blocks", true);
        super.setSkillType(SkillType.ADVANCED);
    }

    protected BlockSize(String name, String description) {
        super(name, description, true);
    }

    protected BlockSize(String name, String description, boolean isTarget) {
        super(name, description, isTarget);
    }

    public BlockSize(PowerOf2 size, String name, String description) {
        this();
        this.inBlockSize = new InPowerOf2(true, name, description, size);
    }

    public InPowerOf2 getInBlockSize() {
        return this.inBlockSize;
    }

    public void setInBlahblah(String name, String description) {
        this.inAudio = new InAudio(name, description);
    }

    public void setOutBlahblah(String name, String description) {
        this.outAudio = new OutAudio(name, description);
    }

    @Override
    public void fullCycle(FlowEngine engine) {
        this.isWaveRead = false;
        this.readParameters(engine);
        this.setup();
        this.process(engine);
    }

    private void readParameters(FlowEngine engine) {
        if (this.srcWave == null) {
            engine.requestData(this.inAudio);
            this.srcWave = (WaveData)this.inAudio.read();
            this.srcOffset = 0;
            this.isWaveRead = true;
        }
        this.inputSize = this.srcWave.nbFrames;
        if (this.srcOffset == 0) {
            this.ensureInput(this.inBlockSize, engine);
            this.outputSize = ((PowerOf2)((Object)this.inBlockSize.read())).intValue();
        }
    }

    private void setup() {
        boolean changes = this.outAudio.prepare(this.srcWave.nbChannels, this.outputSize, this.windowing);
        if (changes || this.isDirty) {
            if (!this.srcWave.windowing.getOverlapping().equals((Object)PowerOf2.p1)) {
                super.log(GraphErrorType.IllegalArgument, Severity.Warning, "Warning: input is windowed. This is not supported", new Object[0]);
            }
            float[] window = WindowFactory.getWindow(WindowType.Rectangular, this.outputSize);
            this.windowing = new WindowInfo(window, PowerOf2.p1);
            this.dstOffset = 0;
            if (this.outputSize > this.inputSize) {
                this.dstOffset = this.outputSize - this.inputSize;
            }
            this.isDirty = false;
        }
    }

    private void process(FlowEngine engine) {
        int remaining;
        int available;
        WaveData dstWave = (WaveData)this.outAudio.get();
        dstWave.windowing = this.windowing;
        if (this.srcOffset >= this.srcWave.nbFrames) {
            if (this.inAudio.isConnected() && !this.isWaveRead) {
                engine.requestData(this.inAudio);
                this.isWaveRead = true;
            }
            this.srcWave = (WaveData)this.inAudio.read();
            this.srcOffset = 0;
        }
        int count = (available = this.srcWave.nbFrames - this.srcOffset) < (remaining = this.outputSize - this.dstOffset) ? available : remaining;
        int chan = 0;
        while (chan < this.srcWave.nbChannels) {
            float[] in = this.srcWave.data[chan];
            float[] out = dstWave.data[chan % dstWave.nbChannels];
            int i = 0;
            while (i < count) {
                out[this.dstOffset + i] = in[this.srcOffset + i];
                ++i;
            }
            ++chan;
        }
        this.dstOffset += count;
        this.srcOffset += count;
        this.outAudio.setReady(false);
        if (this.dstOffset >= this.outputSize) {
            this.dstOffset = 0;
            this.outAudio.setReady(true);
        }
    }

    @Override
    public void cycle() {
    }

    @Override
    protected void reset() {
        super.reset();
        this.srcWave = null;
        this.isDirty = true;
        this.srcOffset = 0;
        this.dstOffset = 0;
    }

    @Override
    public Fraction timeSkew() {
        assert (this.inputSize != 0);
        if (this.timeSkew == null || !this.timeSkew.equals(this.outputSize, this.inputSize)) {
            this.timeSkew = new Fraction(this.outputSize, this.inputSize).seal();
        }
        return this.timeSkew;
    }

    @Override
    public int getLatency() {
        if (this.outputSize > this.inputSize) {
            return this.outputSize - this.inputSize;
        }
        return 0;
    }
}

