/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.convert.format;

import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.convert.format.BlockSize;
import org.corebounce.decklight.bouncelets.audio.convert.format.advanced.BackwardFFT;
import org.corebounce.decklight.bouncelets.audio.convert.format.advanced.MergeWindows;
import org.corebounce.decklight.bouncelets.audio.ports.InPowerOf2;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.InWindowType;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.macro.Connector;
import org.corebounce.decklight.macro.MacroBouncelet;
import org.corebounce.decklight.ports.InputPort;
import org.corebounce.decklight.ports.OutputPort;

public class SpectrumToWave
extends MacroBouncelet {
    private final BackwardFFT backFFT = new BackwardFFT();
    private final MergeWindows merge = new MergeWindows();
    private final BlockSize blockSize = new BlockSize(AudioConfig.getBlockSize(), "blockSize", "Output block size");

    public SpectrumToWave() {
        super("audio.convert.format.spectrum2wave", "Convert audio spectrum to audio wave");
        super.setSkillType(SkillType.ADVANCED);
        this.blockSize.getInBlockSize().setSkillType(SkillType.EXPERT);
    }

    public void setOutBlahblah(String name, String description) {
        this.blockSize.setOutBlahblah(name, description);
    }

    public InSpectrum inSpectrum() {
        return this.backFFT.inSpectrum;
    }

    public OutAudio outAudio() {
        return this.blockSize.outAudio;
    }

    public InWindowType inWindow() {
        return this.merge.inPostWindow;
    }

    public InPowerOf2 inBlockSize() {
        return this.blockSize.inBlockSize;
    }

    public Bouncelet[] getParts() {
        return new Bouncelet[]{this.backFFT, this.merge, this.blockSize};
    }

    @Override
    public void createInternalConnections(Connector connector) {
        connector.connect(this.backFFT.outAudio, this.merge.inAudio);
        connector.connect(this.merge.outAudio, this.blockSize.inAudio);
    }

    @Override
    protected InputPort<?>[] getMacroInputPorts() {
        return new InputPort[]{this.backFFT.inSpectrum, this.merge.inPostWindow, this.blockSize.inBlockSize};
    }

    @Override
    protected OutputPort<?>[] getMacroOutputPorts() {
        return new OutputPort[]{this.blockSize.outAudio};
    }
}

