/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.convert.format;

import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.decklight.bouncelets.audio.convert.format.BlockSize;
import org.corebounce.decklight.bouncelets.audio.convert.format.advanced.ForwardFFT;
import org.corebounce.decklight.bouncelets.audio.convert.format.advanced.SplitWindows;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.InPowerOf2;
import org.corebounce.decklight.bouncelets.audio.ports.InWindowType;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.bouncelets.signal.PowerOf2Div;
import org.corebounce.decklight.bouncelets.signal.values.PowerOfTwo;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.macro.Connector;
import org.corebounce.decklight.macro.MacroBouncelet;
import org.corebounce.decklight.ports.InputPort;
import org.corebounce.decklight.ports.OutputPort;

public class WaveToSpectrum
extends MacroBouncelet {
    private final PowerOfTwo overlap = new PowerOfTwo("overlap", "Overlapping factor", PowerOf2.p4, PowerOf2.p1, PowerOf2.p64);
    private final PowerOfTwo windowSize = new PowerOfTwo("blockSize", "Window size for the FFT", PowerOf2.p2048, PowerOf2.p32, PowerOf2.p262144);
    private final PowerOf2Div divisor = new PowerOf2Div();
    private final BlockSize blockSize = new BlockSize();
    private final SplitWindows split = new SplitWindows();
    private final ForwardFFT forwFFT = new ForwardFFT();

    public WaveToSpectrum() {
        super("audio.convert.format.wave2spectrum", "Convert audio wave to audio spectrum");
        super.setSkillType(SkillType.ADVANCED);
    }

    public void setInBlahblah(String name, String description) {
        this.blockSize.setInBlahblah(name, description);
    }

    public InAudio inAudio() {
        return this.blockSize.inAudio;
    }

    public OutSpectrum outSpectrum() {
        return this.forwFFT.outAudio;
    }

    public InPowerOf2 inOverlap() {
        return this.overlap.inData;
    }

    public InPowerOf2 inWindowSize() {
        return this.windowSize.inData;
    }

    public InWindowType inWindowType() {
        return this.split.inWindowType;
    }

    public Bouncelet[] getParts() {
        return new Bouncelet[]{this.overlap, this.windowSize, this.divisor, this.blockSize, this.split, this.forwFFT};
    }

    @Override
    public void createInternalConnections(Connector connector) {
        connector.connect(this.windowSize.outData, this.divisor.inValue1);
        connector.connect(this.overlap.outData, this.divisor.inValue2);
        connector.connect(this.divisor.outResult, this.blockSize.inBlockSize);
        connector.connect(this.windowSize.outData, this.split.inWindowSize);
        connector.connect(this.blockSize.outAudio, this.split.inAudio);
        connector.connect(this.split.outAudio, this.forwFFT.inAudio);
    }

    @Override
    protected InputPort<?>[] getMacroInputPorts() {
        return new InputPort[]{this.blockSize.inAudio, this.overlap.inData, this.windowSize.inData, this.split.inWindowType};
    }

    @Override
    protected OutputPort<?>[] getMacroOutputPorts() {
        return new OutputPort[]{this.forwFFT.outAudio};
    }
}

