/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.convert.format;

import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.decklight.bouncelets.audio.base.WindowType;
import org.corebounce.decklight.bouncelets.audio.convert.format.BlockSize;
import org.corebounce.decklight.bouncelets.audio.convert.format.advanced.MergeWindows;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.macro.Connector;
import org.corebounce.decklight.macro.MacroBouncelet;
import org.corebounce.decklight.ports.InputPort;
import org.corebounce.decklight.ports.OutputPort;

public class WindowsToWave
extends MacroBouncelet {
    private final MergeWindows merge = new MergeWindows();
    private final BlockSize blockSize = new BlockSize(PowerOf2.p64, "blockSize", "Output block size");

    public WindowsToWave() {
        super("audio.convert.format.windows2wave", "Convert audio windows to audio wave");
        super.setSkillType(SkillType.EXPERT);
    }

    public InAudio getInAudio() {
        return this.merge.inAudio;
    }

    public OutAudio getOutAudio() {
        return this.blockSize.outAudio;
    }

    public MergeWindows getMerger() {
        return this.merge;
    }

    public Bouncelet[] getParts() {
        return new Bouncelet[]{this.merge, this.blockSize};
    }

    @Override
    public void createInternalConnections(Connector connector) {
        connector.connect(this.merge.outAudio, this.blockSize.inAudio);
        this.merge.inPostWindow.write(WindowType.Rectangular);
    }

    @Override
    protected InputPort<?>[] getMacroInputPorts() {
        return new InputPort[]{this.merge.inAudio, this.merge.inPostWindow, this.blockSize.inBlockSize};
    }

    @Override
    protected OutputPort<?>[] getMacroOutputPorts() {
        return new OutputPort[]{this.blockSize.outAudio};
    }
}

