/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.convert.format.advanced;

import org.corebounce.common.dsp.fft.BooFFT;
import org.corebounce.common.dsp.fft.Windows;
import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.GraphErrorType;
import org.corebounce.decklight.bouncelets.audio.base.SpectrumData;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.base.WindowInfo;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.utils.Severity;

public class BackSTFT
extends Bouncelet {
    public InSpectrum inSpectrum = new InSpectrum("in", "Input audio spectrum");
    public OutAudio outAudio = new OutAudio("out", "Output audio wave");
    private int blockSize;
    private int overlapping;
    private int hopSize;
    private int overlapSize;
    private BooFFT fft;
    private float[][] merger;
    private int index;
    private float correction;
    private WindowInfo windowing;

    public BackSTFT() {
        super("audio.convert.format.advanced.BackSTFT", "Simplified backward STFT");
        super.setSkillType(SkillType.EXPERT);
    }

    @Override
    public void cycle() {
        this.setup();
        this.process();
    }

    private void setup() {
        SpectrumData spectrum = (SpectrumData)this.inSpectrum.peek();
        this.blockSize = spectrum.getNbFrames();
        if (spectrum.windowing.isWindowModified()) {
            this.overlapping = spectrum.windowing.getOverlapping().intValue();
        }
        this.hopSize = this.blockSize / this.overlapping;
        this.overlapSize = this.blockSize - this.hopSize;
        boolean changes = this.outAudio.prepare(spectrum.nbChannels, this.hopSize, this.windowing);
        if (changes || spectrum.windowing.isWindowModified()) {
            this.fft = new BooFFT(this.blockSize / 2);
            this.merger = new float[spectrum.nbChannels][this.overlapSize];
            this.index = 0;
            if (this.overlapping >= 4) {
                this.correction = Windows.getHannCorrection(this.overlapping, 2);
            } else {
                super.log(GraphErrorType.IllegalArgument, Severity.Warning, "Overlapping factor must be at least 4. Currently: {0}", this.overlapping);
                this.correction = 1.0f;
            }
            this.windowing = WindowInfo.noWindow(this.blockSize);
        } else {
            this.windowing.setWindowModified(false);
        }
    }

    private void process() {
        SpectrumData spectrum = (SpectrumData)this.inSpectrum.read();
        WaveData wave = (WaveData)this.outAudio.get();
        assert (wave.nbFrames == this.hopSize);
        wave.windowing = this.windowing;
        int chan = 0;
        while (chan < spectrum.nbChannels) {
            Cmplx[] input = spectrum.data[chan];
            float[] output = wave.data[chan];
            Windows.convolveHann(input);
            this.fft.backC2Rola(input, output, this.merger[chan], this.index, this.correction);
            ++chan;
        }
        this.index = (this.index + this.hopSize) % this.overlapSize;
    }
}

