/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.convert.format.advanced;

import org.corebounce.common.dsp.fft.BooFFT;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.decklight.bouncelets.audio.base.SpectrumData;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.base.WindowInfo;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.SkillType;

public class BackwardFFT
extends Bouncelet {
    public InSpectrum inSpectrum = new InSpectrum("in", "Input Audio Spectrum");
    public OutAudio outAudio = new OutAudio("out", "Output Audio Wave");
    private BooFFT fft;
    private WindowInfo windowing;
    private int padFactor = 0;

    public BackwardFFT() {
        super("audio.convert.format.advanced.BackwardFFT", "Backward Fourier Transform");
        super.setSkillType(SkillType.EXPERT);
    }

    @Override
    public void cycle() {
        this.setup();
        this.process();
    }

    private void setup() {
        SpectrumData spectrum = (SpectrumData)this.inSpectrum.peek();
        int nbFrames = spectrum.getNbFrames();
        int padFactor = spectrum.windowing.getZeroPadding().intValue();
        boolean changes = this.outAudio.prepare(spectrum.nbChannels, nbFrames, this.windowing);
        if (changes || this.padFactor != padFactor) {
            int targetSize = nbFrames * padFactor;
            this.fft = new BooFFT(targetSize / 2);
            this.windowing = new WindowInfo(spectrum.windowing);
            this.padFactor = padFactor;
            this.windowing.setZeroPadding(PowerOf2.p1);
            this.windowing.setWindowModified(spectrum.windowing.isWindowModified());
        } else if (spectrum.windowing.isWindowModified()) {
            this.windowing.copyFrom(spectrum.windowing);
            this.windowing.setZeroPadding(PowerOf2.p1);
        } else {
            this.windowing.setWindowModified(false);
        }
    }

    private void process() {
        SpectrumData spectrum = (SpectrumData)this.inSpectrum.read();
        int padFactor = spectrum.windowing.getZeroPadding().intValue();
        WaveData wave = (WaveData)this.outAudio.get();
        wave.windowing = this.windowing;
        int chan = 0;
        while (chan < wave.nbChannels) {
            this.fft.backC2RPadded(spectrum.data[chan], wave.data[chan], padFactor);
            ++chan;
        }
    }
}

