/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.convert.format.advanced;

import org.corebounce.common.dsp.fft.BooFFT;
import org.corebounce.common.dsp.fft.Windows;
import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.decklight.bouncelets.audio.base.SpectrumData;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.base.WindowFactory;
import org.corebounce.decklight.bouncelets.audio.base.WindowInfo;
import org.corebounce.decklight.bouncelets.audio.base.WindowType;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.InPowerOf2;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.bridge.SkillType;

public class ForwSTFT
extends Bouncelet {
    public InAudio inAudio = new InAudio("in", "Input audio wave");
    public InPowerOf2 inBlockSize = new InPowerOf2(true, "blockSize", "Block size", PowerOf2.p2048);
    public OutSpectrum outSpectrum = new OutSpectrum("out", "Output audio spectrum");
    private int hopSize;
    private int blockSize;
    private float[][] buffer;
    private int index;
    private BooFFT fft;
    private WindowInfo windowing;

    public ForwSTFT() {
        super("audio.convert.format.advanced.ForwSTFT", "Simplified Forward STFT");
        super.setSkillType(SkillType.EXPERT);
    }

    @Override
    public void cycle() {
        this.setup();
        this.process();
    }

    private void setup() {
        int nbBins;
        boolean changes;
        WaveData wave = (WaveData)this.inAudio.peek();
        if (this.inBlockSize.isModified()) {
            this.blockSize = ((PowerOf2)((Object)this.inBlockSize.read())).intValue();
        }
        if ((changes = this.outSpectrum.prepare(wave.nbChannels, nbBins = this.blockSize / 2 + 1, 1, null, this.windowing)) || wave.nbFrames != this.hopSize) {
            this.hopSize = wave.nbFrames;
            this.buffer = new float[wave.nbChannels][this.blockSize];
            this.index = 0;
            this.fft = new BooFFT(this.blockSize / 2);
            PowerOf2 overlapping = PowerOf2.fromInt(this.blockSize / this.hopSize);
            float[] window = WindowFactory.getWindow(WindowType.Hann, this.blockSize);
            this.windowing = new WindowInfo(window, overlapping);
            this.windowing.setWindowModified(true);
        } else {
            this.windowing.setWindowModified(false);
        }
    }

    private void process() {
        WaveData wave = (WaveData)this.inAudio.read();
        assert (wave.nbFrames == this.hopSize);
        SpectrumData spectrum = (SpectrumData)this.outSpectrum.get();
        spectrum.windowing = this.windowing;
        int chan = 0;
        while (chan < wave.nbChannels) {
            System.arraycopy(wave.data[chan], 0, this.buffer[chan], this.index, this.hopSize);
            ++chan;
        }
        this.index = (this.index + this.hopSize) % this.blockSize;
        chan = 0;
        while (chan < wave.nbChannels) {
            Cmplx[] output = spectrum.data[chan];
            this.fft.forwR2C(this.buffer[chan], this.index, this.blockSize, output);
            Windows.convolveHann(output);
            ++chan;
        }
    }
}

