/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.convert.format.advanced;

import org.corebounce.common.dsp.fft.BooFFT;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.decklight.bouncelets.audio.base.SpectrumData;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.base.WindowInfo;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.InPowerOf2;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.bridge.SkillType;

public class ForwardFFT
extends Bouncelet {
    public InAudio inAudio = new InAudio("in", "Input Audio Wave");
    public InPowerOf2 inZeroPadding = new InPowerOf2(true, "zeroPadding", "Zero padding amount", PowerOf2.p1, PowerOf2.p1, PowerOf2.p64);
    public OutSpectrum outAudio = new OutSpectrum("out", "Output Audio Spectrum");
    private BooFFT fft;
    private WindowInfo windowing;
    private int padFactor = 0;

    public ForwardFFT() {
        super("audio.convert.format.advanced.ForwardFFT", "Forward Fourier Transform");
        super.setSkillType(SkillType.EXPERT);
        this.inZeroPadding.setSkillType(SkillType.EXPERT);
    }

    @Override
    public void cycle() {
        this.setup();
        this.process();
    }

    private void setup() {
        WaveData wave = (WaveData)this.inAudio.peek();
        PowerOf2 zeroPadding = (PowerOf2)((Object)this.inZeroPadding.read());
        int padFactor = zeroPadding.intValue();
        int nbBins = wave.getNbBins(zeroPadding);
        boolean changes = this.outAudio.prepare(wave.nbChannels, nbBins, 1, null, this.windowing);
        if (changes || this.padFactor != padFactor) {
            int sourceSize = wave.nbFrames * padFactor;
            this.fft = new BooFFT(sourceSize / 2);
            this.padFactor = padFactor;
            this.windowing = new WindowInfo(wave.windowing.getWindow(), wave.windowing.getOverlapping());
            this.windowing.setZeroPadding(zeroPadding);
            this.windowing.setWindowModified(wave.windowing.isWindowModified());
        } else if (wave.windowing.isWindowModified()) {
            this.windowing.copyFrom(wave.windowing);
            this.windowing.setZeroPadding(PowerOf2.p1);
        } else {
            this.windowing.setWindowModified(false);
        }
    }

    private void process() {
        WaveData wave = (WaveData)this.inAudio.read();
        PowerOf2 zeroPadding = (PowerOf2)((Object)this.inZeroPadding.read());
        int padFactor = zeroPadding.intValue();
        SpectrumData spectrum = (SpectrumData)this.outAudio.get();
        spectrum.windowing = this.windowing;
        int chan = 0;
        while (chan < wave.nbChannels) {
            this.fft.forwR2CPadded(wave.data[chan], spectrum.data[chan], padFactor);
            ++chan;
        }
    }
}

