/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.convert.format.advanced;

import org.corebounce.common.dsp.fft.UnityRoots;
import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.FrequenciesData;
import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.decklight.bouncelets.audio.base.SpectrumData;
import org.corebounce.decklight.bouncelets.audio.base.WindowFactory;
import org.corebounce.decklight.bouncelets.audio.base.WindowInfo;
import org.corebounce.decklight.bouncelets.audio.base.WindowType;
import org.corebounce.decklight.bouncelets.audio.ports.InFrequencies;
import org.corebounce.decklight.bouncelets.audio.ports.InPowerOf2;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.bridge.SkillType;

public class FrequenciesToSpectrum
extends Bouncelet {
    private static final int MULT = 77;
    private static final int ADD = 37;
    public InFrequencies inFreqs = new InFrequencies("in", "Frequencies");
    public InPowerOf2 inOverlapping = new InPowerOf2(true, "overlapping", "Overlapping factor", PowerOf2.p2);
    public OutSpectrum outSpectrum = new OutSpectrum("out", "Generated spectrum");
    private Cmplx[] phasingRoots;
    private Cmplx[] randomizingRoots;
    private int curPhase;
    private int nbPhases;
    private WindowInfo windowing;

    public FrequenciesToSpectrum() {
        super("audio.convert.format.advanced.frequencies2spectrum", "Generate spectrum using frequencies");
        super.setSkillType(SkillType.EXPERT);
        this.inOverlapping.setSkillType(SkillType.ADVANCED);
    }

    @Override
    public void cycle() {
        this.setup();
        this.process();
    }

    private void setup() {
        FrequenciesData freqs = (FrequenciesData)this.inFreqs.read();
        PowerOf2 oFactor = (PowerOf2)((Object)this.inOverlapping.read());
        boolean changes = false;
        if (oFactor.intValue() != this.nbPhases) {
            changes = true;
            this.nbPhases = oFactor.intValue();
            this.curPhase %= this.nbPhases;
            this.phasingRoots = UnityRoots.getInstance().getRoots(this.nbPhases, this.nbPhases);
        }
        SpectrumData spectrum = (SpectrumData)this.outSpectrum.get();
        int nbFrames = spectrum.getNbFrames();
        if (changes |= this.outSpectrum.prepare(freqs.nbChannels, freqs.nbBins, 1, null, this.windowing)) {
            float[] window = WindowFactory.getWindow(WindowType.Rectangular, nbFrames);
            this.windowing = new WindowInfo(window, oFactor);
            this.randomizingRoots = UnityRoots.getInstance().getRoots(nbFrames, nbFrames);
        } else {
            this.windowing.setWindowModified(false);
        }
    }

    private void process() {
        FrequenciesData freqs = (FrequenciesData)this.inFreqs.read();
        SpectrumData spectrum = (SpectrumData)this.outSpectrum.get();
        int nbFrames = spectrum.getNbFrames();
        spectrum.windowing = this.windowing;
        int chan = 0;
        while (chan < freqs.nbChannels) {
            Cmplx[] out = spectrum.data[chan];
            float[] in = freqs.data[chan];
            assert (out.length == in.length);
            int index = 0;
            int i = 0;
            while (i < out.length) {
                Cmplx target = out[i];
                target.set(in[i] * 2.0f, 0.0f);
                if (i > 0 && i < out.length - 1) {
                    target.mul(this.randomizingRoots[index]);
                    index = (index * 77 + 37) % nbFrames;
                    target.mul(this.phasingRoots[i * this.curPhase % this.nbPhases]);
                }
                ++i;
            }
            ++chan;
        }
        this.curPhase = (this.curPhase + 1) % this.nbPhases;
    }
}

