/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.convert.format.asharp;

import org.corebounce.common.dsp.fft.BooFFT;
import org.corebounce.common.dsp.fft.Windows;
import org.corebounce.common.math.Cmplx;

public class Cup {
    private final int blockSize;
    private final int shiftSize;
    private final int nbBins;
    private final float analysisShrink;
    private final boolean enableEnergyCorrection;
    private BooFFT fft;
    private float[] block;
    private float[] synthesisWindow;
    private float[] invWindow;
    private float[] outBuffer;
    private int outIndex;

    public Cup(int blockSize, int shiftSize, float analysisShrink, float synthesisShrink, boolean energyCorrection) {
        this.blockSize = blockSize;
        this.shiftSize = shiftSize;
        this.nbBins = blockSize / 2 + 1;
        this.analysisShrink = analysisShrink;
        this.fft = new BooFFT(blockSize / 2);
        this.block = new float[blockSize];
        this.synthesisWindow = new float[blockSize];
        float[] analysisWindow = new float[blockSize];
        this.invWindow = new float[shiftSize];
        Windows.fillShrunkWindow(analysisWindow, Windows.HannCoefs, analysisShrink, energyCorrection);
        Windows.fillShrunkWindow(this.synthesisWindow, Windows.HannCoefs, synthesisShrink);
        Windows.fillInverseWindow(analysisWindow, this.synthesisWindow, this.invWindow, blockSize, shiftSize);
        this.outBuffer = new float[blockSize];
        this.enableEnergyCorrection = energyCorrection;
    }

    public void processAdd(Cmplx[] spectrum, float[] output) {
        if (spectrum.length != this.nbBins) {
            throw new IllegalArgumentException();
        }
        if (output.length != this.shiftSize) {
            throw new IllegalArgumentException();
        }
        this.fft.backC2R(spectrum, this.block);
        float energyCorrection = 1.0f;
        if (this.analysisShrink > 1.0f && this.enableEnergyCorrection) {
            float maxCorrection = (float)Math.sqrt(this.analysisShrink);
            int cellSize = (int)((float)this.blockSize / this.analysisShrink + 0.5f);
            int cellStart = (this.blockSize - cellSize) / 2;
            int cellStop = cellStart + cellSize;
            float cellEnergy = 0.0f;
            float blockEnergy = 0.0f;
            int i = 0;
            while (i < this.blockSize) {
                float p = this.block[i] * this.block[i];
                blockEnergy += p;
                if (i >= cellStart && i < cellStop) {
                    cellEnergy += p;
                }
                ++i;
            }
            if (cellEnergy > 0.0f && (energyCorrection = (float)Math.sqrt(blockEnergy / cellEnergy)) > maxCorrection) {
                energyCorrection = maxCorrection;
            }
        }
        int i = 0;
        while (i < this.blockSize - this.shiftSize) {
            int n = (this.outIndex + i) % this.blockSize;
            this.outBuffer[n] = this.outBuffer[n] + this.block[i] * this.synthesisWindow[i] * energyCorrection;
            ++i;
        }
        i = this.blockSize - this.shiftSize;
        while (i < this.blockSize) {
            this.outBuffer[(this.outIndex + i) % this.blockSize] = this.block[i] * this.synthesisWindow[i] * energyCorrection;
            ++i;
        }
        i = 0;
        while (i < this.shiftSize) {
            int n = i;
            output[n] = output[n] + this.outBuffer[i + this.outIndex] * this.invWindow[i];
            ++i;
        }
        this.outIndex = (this.outIndex + this.shiftSize) % this.blockSize;
    }
}

