/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.convert.format.asharp;

import org.corebounce.decklight.bouncelets.audio.Buffer;
import org.corebounce.decklight.bouncelets.audio.convert.format.asharp.Knife;
import org.corebounce.decklight.bouncelets.audio.convert.format.asharp.KnifeInfo;
import org.corebounce.decklight.bouncelets.audio.convert.format.asharp.SharpInfo;

public class Fork {
    private final int nbChans;
    private final int nbLayers;
    private int bufferSize;
    private final int shiftSize;
    private final float[][] inBuffer;
    private final float[][] srcBuffer;
    private final float[][] mlBuffer;
    private final float[][][] outBuffers;
    private int bufferOffset;
    private final Knife[] knifes;
    private final Buffer[][] preDelay;
    private final Buffer[][] postDelay;
    private final float[][][] outputs;

    public Fork(int nbChans, SharpInfo info) {
        this(nbChans, info, false);
    }

    public Fork(int nbChans, SharpInfo info, boolean acceptMelodyLess) {
        int chan;
        int j;
        int totalLatency;
        this.nbChans = nbChans;
        this.nbLayers = info.nbLayers;
        this.bufferSize = info.shiftSize;
        KnifeInfo[] knifeInfoArray = info.knifeInfo;
        int n = info.knifeInfo.length;
        int n2 = 0;
        while (n2 < n) {
            KnifeInfo knifeInfo = knifeInfoArray[n2];
            if (knifeInfo.shiftSize > this.bufferSize) {
                this.bufferSize = knifeInfo.shiftSize;
            }
            ++n2;
        }
        this.shiftSize = info.shiftSize;
        this.inBuffer = new float[nbChans][this.bufferSize];
        this.srcBuffer = new float[nbChans][this.bufferSize];
        this.mlBuffer = (float[][])(acceptMelodyLess ? new float[nbChans][this.bufferSize] : null);
        this.knifes = new Knife[info.nbLayers - 1];
        this.preDelay = new Buffer[Fork.z(info.nbLayers - 2)][nbChans];
        this.postDelay = new Buffer[Fork.z(info.nbLayers - 2)][nbChans];
        this.outBuffers = new float[info.nbLayers][nbChans][this.bufferSize];
        this.outputs = new float[info.nbLayers][nbChans][this.shiftSize];
        int i = 0;
        while (i < this.knifes.length) {
            this.knifes[i] = new Knife(nbChans, info.knifeInfo[i], i == 0 && acceptMelodyLess);
            ++i;
        }
        i = 0;
        while (i < this.preDelay.length) {
            totalLatency = 0;
            j = 0;
            while (j < i + 1) {
                totalLatency += this.knifes[j].getSampleLatency();
                ++j;
            }
            chan = 0;
            while (chan < nbChans) {
                this.preDelay[i][chan] = new Buffer(totalLatency);
                ++chan;
            }
            ++i;
        }
        i = 0;
        while (i < this.postDelay.length) {
            totalLatency = 0;
            j = i + 1;
            while (j < this.knifes.length) {
                totalLatency += this.knifes[j].getSampleLatency();
                ++j;
            }
            chan = 0;
            while (chan < nbChans) {
                this.postDelay[i][chan] = new Buffer(totalLatency);
                ++chan;
            }
            ++i;
        }
    }

    private static int z(int value) {
        return value < 0 ? 0 : value;
    }

    public void process(float[][] input) {
        this.process(input, null);
    }

    public void process(float[][] input, float[][] melodyLess) {
        if (input.length != this.nbChans) {
            throw new IllegalArgumentException("Illegal number of channels");
        }
        int chan = 0;
        while (chan < this.nbChans) {
            if (input[chan].length != this.shiftSize) {
                throw new IllegalArgumentException("Illegal block size");
            }
            System.arraycopy(input[chan], 0, this.inBuffer[chan], this.bufferOffset, this.shiftSize);
            System.arraycopy(input[chan], 0, this.srcBuffer[chan], this.bufferOffset, this.shiftSize);
            if (melodyLess != null) {
                System.arraycopy(melodyLess[chan], 0, this.mlBuffer[chan], this.bufferOffset, this.shiftSize);
            }
            ++chan;
        }
        this.bufferOffset += this.shiftSize;
        if (this.bufferOffset >= this.bufferSize) {
            this.processBlock();
            this.bufferOffset = 0;
        }
        chan = 0;
        while (chan < this.nbChans) {
            int s = 0;
            while (s < this.nbLayers) {
                System.arraycopy(this.outBuffers[s][chan], this.bufferOffset, this.outputs[s][chan], 0, this.shiftSize);
                ++s;
            }
            ++chan;
        }
    }

    private void processBlock() {
        float[][] source;
        float[][] input = this.inBuffer;
        float[][] fArray = source = this.mlBuffer == null ? this.srcBuffer : this.mlBuffer;
        if (this.knifes.length > 0) {
            int s = 0;
            while (s < this.knifes.length) {
                int chan;
                if (s == 0 && this.mlBuffer != null) {
                    this.knifes[s].processMonitored(source, input, this.outBuffers[s], this.outBuffers[s + 1]);
                } else {
                    this.knifes[s].process(source, input, this.outBuffers[s], this.outBuffers[s + 1]);
                }
                input = this.outBuffers[s + 1];
                if (s < this.postDelay.length) {
                    chan = 0;
                    while (chan < this.nbChans) {
                        this.postDelay[s][chan].pushArray(this.outBuffers[s][chan]);
                        ++chan;
                    }
                }
                if (s < this.preDelay.length) {
                    chan = 0;
                    while (chan < this.nbChans) {
                        this.preDelay[s][chan].pushArray(this.srcBuffer[chan]);
                        ++chan;
                    }
                }
                source = this.srcBuffer;
                ++s;
            }
        } else {
            int chan = 0;
            while (chan < this.nbChans) {
                System.arraycopy(input[chan], 0, this.outBuffers[0][chan], 0, input[chan].length);
                ++chan;
            }
        }
    }

    public float[] getOutput(int layer, int chan) {
        return this.outputs[layer][chan];
    }

    public int getSampleLatency() {
        int total = 0;
        Knife[] knifeArray = this.knifes;
        int n = this.knifes.length;
        int n2 = 0;
        while (n2 < n) {
            Knife knife = knifeArray[n2];
            total += knife.getSampleLatency();
            ++n2;
        }
        return total += this.bufferSize - this.shiftSize;
    }

    public int getNbChans() {
        return this.nbChans;
    }
}

