/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.convert.format.asharp;

import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.decklight.bouncelets.audio.convert.format.asharp.HqxMode;
import org.corebounce.decklight.bouncelets.audio.convert.format.asharp.SharpInfo;
import org.corebounce.decklight.bouncelets.audio.ports.OutPowerOf2;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InputPort;
import org.corebounce.decklight.ports.ValueOutputPort;

public class HqxToParams
extends Bouncelet {
    public InputPort<HqxMode> inMode = new InputPort<HqxMode>(HqxMode.class, "mode", "HQX Mode", HqxMode.TRIPLE_HIGH);
    public ValueOutputPort<HqxMode> outMode = new ValueOutputPort<HqxMode>(HqxMode.class, "hqxMode", "HQX Mode");
    public OutPowerOf2 outBlockSize = new OutPowerOf2("blockSize", "Block size");

    public HqxToParams() {
        super("audio.convert.format.asharp.hqx2params", "Hqx2params");
        super.setSkillType(SkillType.EXPERT);
    }

    @Override
    public void cycle() {
        if (this.inMode.isModified()) {
            HqxMode mode = this.inMode.read();
            SharpInfo info = mode.getInfo();
            this.outMode.write(mode);
            this.outBlockSize.write(PowerOf2.fromInt(info.shiftSize));
        } else {
            this.outMode.setModified(false);
            this.outBlockSize.setModified(false);
        }
    }
}

