/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.convert.format.asharp;

public class LayerInfo {
    public final int blockSize;
    public final int shiftSize;
    public final float analysisShrink;
    public final float synthesisShrink;
    public final boolean enableEnergyCorrection;

    public LayerInfo(int blockSize, int shiftSize, float analysisShrink, float synthesisShrink, boolean enableEnergyCorrection) {
        if (!LayerInfo.isPowerOf2(blockSize) || !LayerInfo.isPowerOf2(shiftSize) || shiftSize >= blockSize) {
            throw new IllegalArgumentException("Invalid STFT parameters");
        }
        if (analysisShrink < 1.0f || analysisShrink >= (float)blockSize) {
            throw new IllegalArgumentException("Invalid analysis shrink");
        }
        if (synthesisShrink < 1.0f || synthesisShrink >= (float)blockSize) {
            throw new IllegalArgumentException("Invalid synthesis shrink");
        }
        this.blockSize = blockSize;
        this.shiftSize = shiftSize;
        this.analysisShrink = analysisShrink;
        this.synthesisShrink = synthesisShrink;
        this.enableEnergyCorrection = enableEnergyCorrection;
    }

    private static boolean isPowerOf2(int value) {
        return value >= 2 && (value & value - 1) == 0;
    }

    public int getCeilFftSize() {
        float resolution = this.getAnalysisResolution();
        int result = 1;
        while ((float)result < resolution) {
            result *= 2;
        }
        return result;
    }

    public float getAnalysisResolution() {
        return (float)this.blockSize / this.analysisShrink;
    }

    public String toString() {
        return "LayerInfo[" + this.blockSize + ":" + this.shiftSize + "/(" + this.analysisShrink + "|" + this.synthesisShrink + ")]";
    }
}

