/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.convert.format.asharp;

import org.corebounce.decklight.bouncelets.audio.convert.format.asharp.HqxMode;
import org.corebounce.decklight.bouncelets.audio.convert.format.asharp.KnifeInfo;
import org.corebounce.decklight.bouncelets.audio.convert.format.asharp.LayerInfo;

public class SharpInfo {
    public final int nbLayers;
    public final KnifeInfo[] knifeInfo;
    public final LayerInfo[] layerInfo;
    public final int blockSize;
    public final int shiftSize;

    public SharpInfo(KnifeInfo[] knifeInfos, LayerInfo[] layerInfos) {
        if (knifeInfos.length + 1 != layerInfos.length) {
            throw new IllegalArgumentException("Sizes do not match");
        }
        this.nbLayers = layerInfos.length;
        this.knifeInfo = knifeInfos;
        this.layerInfo = layerInfos;
        SharpInfo.checkValidity(layerInfos);
        this.blockSize = layerInfos[0].blockSize;
        this.shiftSize = layerInfos[0].shiftSize;
    }

    public SharpInfo(float maxSize, int nbLayers, float shrink, float maxSynthesisSize, float minOverlap) {
        this(maxSize, nbLayers, shrink, maxSynthesisSize, minOverlap, true);
    }

    public SharpInfo(float maxSize, int nbLayers, float shrink, float maxSynthesisSize, float minOverlap, boolean energyCorrection) {
        if (nbLayers < 1) {
            throw new IllegalArgumentException();
        }
        if (nbLayers > 3) {
            throw new UnsupportedOperationException("nbLayer > 3 unimplemented");
        }
        this.nbLayers = nbLayers;
        this.knifeInfo = new KnifeInfo[nbLayers - 1];
        if (nbLayers >= 2) {
            this.knifeInfo[0] = new KnifeInfo(128, 32, 24, 20, 10, 3, 5.0, 0, 1.0, false);
        }
        if (nbLayers >= 3) {
            this.knifeInfo[1] = new KnifeInfo(512, 128, 24, 20, 10, 3, 5.0, 0, 3.0, false);
        }
        this.blockSize = SharpInfo.getFftSize(maxSize);
        float minSize = maxSize;
        int i = 1;
        while (i < nbLayers) {
            minSize /= shrink;
            ++i;
        }
        this.shiftSize = SharpInfo.getShiftSize(minSize, minOverlap);
        float curSize = maxSize;
        this.layerInfo = new LayerInfo[nbLayers];
        int layer = nbLayers - 1;
        while (layer >= 0) {
            float analysisShrink;
            float synthesisShrink = analysisShrink = (float)this.blockSize / curSize;
            if (curSize > maxSynthesisSize) {
                synthesisShrink = (float)this.blockSize / maxSynthesisSize;
            }
            this.layerInfo[layer] = new LayerInfo(this.blockSize, this.shiftSize, analysisShrink, synthesisShrink, energyCorrection);
            curSize /= shrink;
            --layer;
        }
    }

    private static int getFftSize(float resolution) {
        int fftSize = 2;
        while ((float)fftSize < resolution) {
            fftSize *= 2;
        }
        return fftSize;
    }

    public static int getShiftSize(float resolution, float minOverlap) {
        int shiftSize = 2;
        while ((float)shiftSize <= resolution / minOverlap) {
            shiftSize *= 2;
        }
        return shiftSize / 2;
    }

    private static void checkValidity(LayerInfo ... infos) {
        if (infos.length <= 0) {
            throw new IllegalArgumentException();
        }
        int blockSize = infos[0].blockSize;
        int shiftSize = infos[0].shiftSize;
        int i = 1;
        while (i < infos.length) {
            if (infos[i].blockSize != blockSize || infos[i].shiftSize != shiftSize) {
                throw new IllegalArgumentException();
            }
            ++i;
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("{");
        int layer = 0;
        while (layer < this.nbLayers) {
            if (layer > 0) {
                result.append(" : ");
            }
            result.append(this.layerInfo[layer].toString());
            if (layer < this.knifeInfo.length) {
                result.append(" : ");
                result.append(this.knifeInfo[layer].toString());
            }
            ++layer;
        }
        result.append("}");
        return result.toString();
    }

    public static void main(String[] args) {
        HqxMode[] hqxModeArray = HqxMode.values();
        int n = hqxModeArray.length;
        int n2 = 0;
        while (n2 < n) {
            HqxMode mode = hqxModeArray[n2];
            System.out.println(mode.name());
            System.out.println(" " + mode.getInfo());
            ++n2;
        }
    }
}

