/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect;

import org.corebounce.common.math.Fraction;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.FloatQueue;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.ports.InputPort;

public abstract class VariableRatePullBouncelet
extends Bouncelet {
    public OutAudio outAudio = new OutAudio("out", "Output Audio Wave"){

        @Override
        public boolean isManual() {
            return true;
        }

        @Override
        protected WaveData fetch(InputPort<? super WaveData> target) {
            VariableRatePullBouncelet.this.cycleOutput();
            WaveData result = (WaveData)super.fetch(target);
            this.setModified(true);
            return result;
        }
    };
    private Fraction prevRatio = null;
    protected int nbFrames;
    protected int nbChans;
    private WaveData inData;
    protected FloatQueue[] inputQueue;

    public VariableRatePullBouncelet(String name, String description) {
        super(name, description, true);
    }

    protected abstract InAudio getInAudio();

    protected abstract Fraction getRatio();

    protected abstract int getMaxPreSamples(Fraction var1);

    @Override
    protected void reset() {
        super.reset();
        this.inputQueue = null;
    }

    @Override
    public final void cycle() {
        this.pushInputBlock();
    }

    private WaveData getInData(boolean absorb) {
        if (this.inData == null) {
            this.inData = (WaveData)this.getInAudio().read();
        }
        WaveData result = this.inData;
        if (absorb) {
            this.inData = null;
        }
        return result;
    }

    private void cycleOutput() {
        boolean changes = this.setupRequired();
        changes |= this.commonSetup(changes);
        this.setup(changes);
        this.process();
    }

    private boolean commonSetup(boolean changes) {
        Fraction ratio = this.getRatio();
        WaveData srcWave = this.getInData(false);
        if ((changes |= this.outAudio.prepare(srcWave.nbChannels, srcWave.nbFrames, srcWave.windowing)) || this.inputQueue == null) {
            int initialBufferSize = (int)((double)srcWave.nbFrames * ratio.doubleValue() + 0.5) + this.getMaxPreSamples(ratio);
            this.inputQueue = new FloatQueue[srcWave.nbChannels];
            int i = 0;
            while (i < srcWave.nbChannels) {
                this.inputQueue[i] = new FloatQueue(initialBufferSize, initialBufferSize + srcWave.nbFrames);
                ++i;
            }
            this.nbFrames = srcWave.nbFrames;
            this.nbChans = srcWave.nbChannels;
            changes = true;
        }
        if (this.prevRatio != ratio) {
            changes = true;
        }
        this.prevRatio = ratio;
        return changes;
    }

    protected boolean setupRequired() {
        return false;
    }

    protected abstract void setup(boolean var1);

    protected abstract void process();

    private void pushInputBlock() {
        WaveData inData = this.getInData(true);
        int chan = 0;
        while (chan < this.nbChans) {
            this.inputQueue[chan].pushArray(inData.data[chan]);
            ++chan;
        }
    }

    @Override
    public Fraction timeSkew() {
        return this.getRatio();
    }
}

