/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.base;

import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.GraphErrorType;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.utils.Severity;

public abstract class BinaryAudioBouncelet
extends Bouncelet {
    public InAudio inAudio1 = new InAudio("in0", "First input audio wave");
    public InAudio inAudio2 = new InAudio("in1", "Second input audio wave");
    public OutAudio outAudio = new OutAudio("out", "Sum of first and second audio wave");

    public BinaryAudioBouncelet(String name, String description) {
        super(name, description);
    }

    @Override
    public void cycle() {
        int nbFrames;
        WaveData inWave1 = (WaveData)this.inAudio1.read();
        WaveData inWave2 = (WaveData)this.inAudio2.read();
        int nbChannels = inWave1.nbChannels > inWave2.nbChannels ? inWave1.nbChannels : inWave2.nbChannels;
        int n = nbFrames = inWave1.nbFrames > inWave2.nbFrames ? inWave2.nbFrames : inWave1.nbFrames;
        if (this.outAudio.prepare(nbChannels, nbFrames, inWave1.windowing) && inWave1.nbFrames != inWave2.nbFrames) {
            super.log(GraphErrorType.IllegalArgument, Severity.Warning, "Cannot combine waves with different block sizes: {0} and {1}", inWave1.nbFrames, inWave2.nbFrames);
        }
        WaveData outWave = (WaveData)this.outAudio.get();
        int chan = 0;
        while (chan < outWave.nbChannels) {
            float[] input1 = inWave1.data[chan % inWave1.nbChannels];
            float[] input2 = inWave2.data[chan % inWave2.nbChannels];
            float[] output = outWave.data[chan];
            this.process(input1, input2, output);
            ++chan;
        }
    }

    public abstract void process(float[] var1, float[] var2, float[] var3);
}

