/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.base;

import org.corebounce.decklight.bouncelets.audio.base.AudioMonoWaveBouncelet;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;

public class Volume
extends AudioMonoWaveBouncelet {
    public InAudio inAudio = new InAudio("in", "Input Channel");
    public InDouble inVolume = new InDouble("volume", "Volume", 1.0, 0.0, 2.0);
    public OutAudio outAudio = new OutAudio("out", "Output Channel");

    public Volume() {
        super("audio.effect.base.volume", "Volume", true);
        super.setSkillType(SkillType.SIMPLIFIED);
        this.inVolume.setSkillType(SkillType.SIMPLIFIED);
    }

    public Volume(String portName, double defaultValue) {
        this(portName, defaultValue, 0.0, 2.0);
    }

    public Volume(String portName, double defaultValue, double minValue, double maxValue) {
        super("audio.effect.base.volume", "Volume", true);
        this.inVolume = new InDouble(portName, portName, defaultValue, minValue, maxValue);
    }

    @Override
    public void process(float[] input, float[] output) {
        double volume = (Double)this.inVolume.read();
        assert (input.length == output.length);
        int i = 0;
        while (i < input.length) {
            output[i] = input[i] * (float)volume;
            ++i;
        }
    }
}

