/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.amplitude;

import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.bouncelets.audio.base.AudioMath;
import org.corebounce.decklight.bouncelets.audio.base.AudioMonoSpectrumBouncelet;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;

public class Compand
extends AudioMonoSpectrumBouncelet {
    private final float NEG_BASE = 100.0f;
    public InSpectrum inAudio = new InSpectrum("in", "Input audio spectrum");
    public InDouble inFactor = new InDouble("factor", "Compression(+)/Expansion(-) factor [dB]", 0.0, -80.0, 80.0);
    public OutSpectrum outAudio = new OutSpectrum("out", "Output audio spectrum");
    private double factorDb;
    private double boost;
    private boolean expand;

    public Compand() {
        super("audio.effect.spectrum.amplitude.compand", "Compress/expand dynamic range", true);
        super.setSkillType(SkillType.ADVANCED);
        this.inFactor.setSkillType(SkillType.SIMPLIFIED);
    }

    @Override
    protected void setup() {
        if (this.inFactor.isModified()) {
            this.factorDb = (Double)this.inFactor.read();
            this.expand = this.factorDb < 0.0;
            this.factorDb = Math.abs(this.factorDb);
            this.boost = this.expand ? AudioMath.dbToLevel(this.factorDb / 4.0) : AudioMath.dbToLevel(this.factorDb / 2.0);
        }
    }

    @Override
    public void process(Cmplx[] input, Cmplx[] output) {
        Cmplx[] source = this.currentSource();
        output[0].set(input[0]);
        int i = 1;
        while (i < input.length) {
            Cmplx in = input[i];
            Cmplx src = source[i];
            output[i].set(in);
            double oldGainDb = AudioMath.powerLevelToDb(src.powerMag());
            if (oldGainDb > -100.0) {
                double newGainDb = this.expand ? oldGainDb - this.factorDb * -oldGainDb / 100.0 : oldGainDb - this.factorDb * (oldGainDb + 100.0) / 100.0;
                double ratio = AudioMath.dbToLevel(newGainDb - oldGainDb);
                output[i].mul((float)(ratio * this.boost));
            }
            ++i;
        }
    }
}

