/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.amplitude;

import org.corebounce.common.math.Cmplx;
import org.corebounce.common.math.ShellSort;
import org.corebounce.decklight.bouncelets.audio.base.AudioExtractSpectrumBouncelet;
import org.corebounce.decklight.bouncelets.audio.base.SpectrumData;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;

public class Monster
extends AudioExtractSpectrumBouncelet {
    public InSpectrum inAudio = new InSpectrum("in", "Input audio spectrum");
    public InDouble inLoudCut = new InDouble("cut.loud", "Loudest frequencies to cut [%]", 5.0, 0.0, 100.0);
    public InDouble inSoftCut = new InDouble("cut.soft", "Softest frequencies to cut [%]", 75.0, 0.0, 100.0);
    public OutSpectrum outAudio = new OutSpectrum("out", "Cropped frequencies");
    public OutSpectrum outOther = new OutSpectrum("other", "Other frequencies");
    private int[] indexes;
    private float[] powerMags;

    public Monster() {
        super("audio.effect.spectrum.amplitude.monster", "Amplitude order-statistics filter");
        super.setSkillType(SkillType.ADVANCED);
        this.inLoudCut.setSkillType(SkillType.SIMPLIFIED);
        this.inLoudCut.setScaleType(ScaleType.LOG2);
    }

    @Override
    protected OutSpectrum getOutput1() {
        return this.outAudio;
    }

    @Override
    protected OutSpectrum getOutput2() {
        return this.outOther;
    }

    @Override
    public void setup() {
        SpectrumData spectrum = (SpectrumData)this.inAudio.peek();
        boolean changes = false;
        changes |= this.outAudio.prepare(spectrum);
        if (changes |= this.outOther.prepare(spectrum)) {
            this.indexes = new int[spectrum.nbBins];
            this.powerMags = new float[spectrum.nbBins];
            int i = 0;
            while (i < this.indexes.length) {
                this.indexes[i] = i;
                ++i;
            }
        }
    }

    @Override
    public void process(int chan, Cmplx[] input, Cmplx[] result, Cmplx[] other) {
        Cmplx[] source = super.currentSource();
        int i = 0;
        while (i < source.length) {
            this.powerMags[i] = source[i].powerMag();
            this.indexes[i] = i;
            ++i;
        }
        ShellSort.sort(this.indexes, this.powerMags, this.indexes.length);
        int loudIndex = (int)((Double)this.inLoudCut.read() * (double)this.indexes.length / 100.0);
        int softIndex = (int)((100.0 - (Double)this.inSoftCut.read()) * (double)this.indexes.length / 100.0);
        int i2 = 0;
        while (i2 < input.length) {
            int index = this.indexes[i2];
            if (i2 < loudIndex != i2 < softIndex) {
                result[index].set(input[index]);
                other[index].set(0.0f, 0.0f);
            } else {
                result[index].set(0.0f, 0.0f);
                other[index].set(input[index]);
            }
            ++i2;
        }
    }
}

