/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.amplitude;

import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.base.AudioExtractSpectrumBouncelet;
import org.corebounce.decklight.bouncelets.audio.base.AudioMath;
import org.corebounce.decklight.bouncelets.audio.base.SpectrumData;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;
import org.corebounce.utils.ShaolinBag;

public class SinNoise2
extends AudioExtractSpectrumBouncelet {
    private static final double MIN_FREQ = 20.0;
    private static final double MAX_FREQ = 22000.0;
    public InSpectrum inAudio = new InSpectrum("in", "Input audio spectrum");
    public InDouble inRank = new InDouble("rank", "Gate rank", 0.3, 0.0, 1.0);
    public InDouble inThreshold = new InDouble("threshold", "Sinusoids threshold [dB]", 5.0, 0.0, 60.0);
    public InDouble inReject = new InDouble("reject", "Level of bins to ignore [dB]", -40.0, -100.0, -10.0);
    public InDouble inLowRange = new InDouble("low-range", "Lowest frequency's range [%]", 7.0, 1.0, 20.0);
    public InDouble inHighRange = new InDouble("high-range", "Highest frequency's range [bin]", 25.0, 10.0, 50.0);
    public OutSpectrum outNoise = new OutSpectrum("noise", "Noise");
    public OutSpectrum outMelody = new OutSpectrum("sin", "Sinusoids");
    private int[] coverages;
    private int[] starts;
    private int[] stops;
    private float[] levels;
    private final ShaolinBag<Float> ranker = new ShaolinBag();

    public SinNoise2() {
        super("audio.effect.spectrum.amplitude.sin-noise2", "Split sinusoids and noise");
        super.setSkillType(SkillType.EXPERT);
    }

    @Override
    protected OutSpectrum getOutput1() {
        return this.outNoise;
    }

    @Override
    protected OutSpectrum getOutput2() {
        return this.outMelody;
    }

    @Override
    protected void setup() {
        SpectrumData data = (SpectrumData)this.inAudio.peek();
        if (this.coverages == null || this.coverages.length != data.nbBins || this.inLowRange.isModified() || this.inHighRange.isModified()) {
            double lowRange = (Double)this.inLowRange.read();
            double highRange = (Double)this.inHighRange.read();
            int nbBins = data.nbBins;
            this.coverages = new int[nbBins];
            int i = 0;
            while (i < this.coverages.length) {
                double freq = (double)i * (double)AudioConfig.getSampleRate() / (double)nbBins;
                if (freq < 20.0) {
                    freq = 20.0;
                } else if (freq > 22000.0) {
                    freq = 22000.0;
                }
                double logRatio = (Math.log(freq) - Math.log(20.0)) / (Math.log(22000.0) - Math.log(20.0));
                double cov = lowRange + (highRange - lowRange) * logRatio;
                this.coverages[i] = (int)(cov + 0.5);
                ++i;
            }
            this.starts = new int[nbBins];
            this.stops = new int[nbBins];
            int bin = 0;
            while (bin < nbBins) {
                int startBin = bin - this.coverages[bin] / 2;
                int stopBin = bin + (this.coverages[bin] + 1) / 2;
                if (startBin < 0) {
                    stopBin += -startBin;
                    startBin = 0;
                } else if (stopBin > this.coverages.length) {
                    startBin -= stopBin - this.coverages.length;
                    stopBin = this.coverages.length;
                }
                this.starts[bin] = startBin;
                this.stops[bin] = stopBin;
                ++bin;
            }
            this.levels = new float[nbBins];
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void process(int chan, Cmplx[] input, Cmplx[] noise, Cmplx[] melody) {
        rank = (Double)this.inRank.read();
        sinThreshold = (float)AudioMath.dbToPowerLevel((Double)this.inThreshold.read());
        rejectThreshold = (float)AudioMath.dbToPowerLevel((Double)this.inReject.read());
        i = 0;
        while (i < input.length) {
            this.levels[i] = input[i].powerMag();
            ++i;
        }
        this.ranker.clear();
        prevStart = 0;
        prevStop = 0;
        lower = 0;
        bin = 0;
        ** GOTO lbl42
        {
            this.ranker.remove(Float.valueOf(this.levels[prevStart++]));
            do {
                if (prevStart < this.starts[bin]) continue block1;
                while (prevStop < this.stops[bin]) {
                    this.ranker.add(Float.valueOf(this.levels[prevStop++]));
                }
                maxLevel = this.ranker.get(this.ranker.size() - 1).floatValue();
                rejectLevel = maxLevel * rejectThreshold;
                if (lower >= this.ranker.size()) {
                    lower = this.ranker.size() - 1;
                }
                while (lower > 0 && this.ranker.get(lower - 1).floatValue() >= rejectLevel) {
                    --lower;
                }
                while (lower < this.ranker.size() && this.ranker.get(lower).floatValue() < rejectLevel) {
                    ++lower;
                }
                pivotIndex = (int)(rank * (double)(this.ranker.size() - lower - 1) + 0.5) + lower;
                pivotLevel = this.ranker.get(pivotIndex).floatValue();
                if (this.levels[bin] >= (pivotLevel *= sinThreshold)) {
                    melody[bin].set(input[bin]);
                    noise[bin].clear();
                } else {
                    melody[bin].clear();
                    noise[bin].set(input[bin]);
                }
                ++bin;
lbl42:
                // 2 sources

            } while (bin < input.length);
        }
    }
}

