/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.amplitude;

import java.util.BitSet;
import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.bouncelets.audio.base.AudioExtractSpectrumBouncelet;
import org.corebounce.decklight.bouncelets.audio.base.AudioMath;
import org.corebounce.decklight.bouncelets.audio.base.SpectrumData;
import org.corebounce.decklight.bouncelets.audio.effect.spectrum.amplitude.NoiseExtractor;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;

public class SinNoise3
extends AudioExtractSpectrumBouncelet {
    public InSpectrum inAudio = new InSpectrum("in", "Input audio spectrum");
    public InDouble inThreshold = new InDouble("threshold", "Sinusoids dominance over median [dB]", 10.0, 0.0, 60.0);
    public OutSpectrum outMelody = new OutSpectrum("sin", "Sinusoids");
    public OutSpectrum outNoise = new OutSpectrum("noise", "Noise");
    private NoiseExtractor engine;
    private transient Cmplx[] source;
    private transient BitSet noiseBins;

    public SinNoise3() {
        super("audio.effect.spectrum.amplitude.sin-noise3", "Split sinusoids and noise");
        super.setSkillType(SkillType.ADVANCED);
        this.inThreshold.setSkillType(SkillType.ADVANCED);
    }

    @Override
    protected OutSpectrum getOutput1() {
        return this.outNoise;
    }

    @Override
    protected OutSpectrum getOutput2() {
        return this.outMelody;
    }

    @Override
    protected void reset() {
        this.engine = null;
        super.reset();
    }

    @Override
    protected void setup() {
        SpectrumData data = (SpectrumData)this.inAudio.peek();
        if (this.engine == null || this.engine.getNbBins() != data.nbBins || this.inThreshold.isModified()) {
            float sinusThreshold = (float)AudioMath.dbToPowerLevel((Double)this.inThreshold.read());
            this.engine = new NoiseExtractor(data.nbBins, sinusThreshold, 16.0f, 150.0f);
        }
        this.source = null;
        this.noiseBins = null;
    }

    @Override
    public void process(int chan, Cmplx[] input, Cmplx[] outNoise, Cmplx[] outMelody) {
        Cmplx[] curSrc = super.currentSource();
        if (curSrc != this.source) {
            this.noiseBins = this.engine.analyze(curSrc);
            this.source = curSrc;
        }
        int i = 0;
        while (i < input.length) {
            if (this.noiseBins.get(i)) {
                outNoise[i].set(input[i]);
                outMelody[i].clear();
            } else {
                outNoise[i].clear();
                outMelody[i].set(input[i]);
            }
            ++i;
        }
    }
}

