/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.channels;

import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.SpectrumData;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.bridge.SkillType;

public class Stereo2Mono
extends Bouncelet {
    public InSpectrum inAudio = new InSpectrum("in", "Input audio spectrum");
    public OutSpectrum outAudio = new OutSpectrum("out", "Output audio spectrum");

    public Stereo2Mono() {
        super("audio.effect.spectrum.channels.stereo2mono", "Convert stereo to mono, avoiding phase cancellations");
        super.setSkillType(SkillType.ADVANCED);
    }

    @Override
    public void cycle() {
        SpectrumData inSpec = (SpectrumData)this.inAudio.read();
        this.outAudio.prepare(1, inSpec.nbBins, inSpec.nbLayers, inSpec.hqxMode, inSpec.windowing);
        float correction = 1.0f / (float)inSpec.nbChannels;
        float[] weights = new float[inSpec.nbBins];
        Cmplx phasor = new Cmplx();
        Cmplx temp = new Cmplx();
        Cmplx[][] input = inSpec.data;
        Cmplx[] output = ((SpectrumData)this.outAudio.get()).data[0];
        int i = 0;
        while (i < output.length) {
            float sum = 0.0f;
            phasor.clear();
            int c = 0;
            while (c < inSpec.nbChannels) {
                float weight;
                temp.set(input[c][i]);
                weights[c] = weight = temp.mag();
                sum += weight;
                phasor.add(temp);
                ++c;
            }
            float resMag = sum * correction;
            float resPhi = phasor.phi();
            temp.set(resMag, resPhi);
            temp.toCartesian();
            output[i].set(temp);
            ++i;
        }
    }
}

