/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.channels;

import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.SpectrumData;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InBoolean;
import org.corebounce.decklight.ports.InInt;

public class StereoToQuad
extends Bouncelet {
    public InSpectrum inAudio = new InSpectrum("in", "Input audio spectrum");
    public InBoolean inSurround = new InBoolean(true, "surround", "Enable surround (rear) channel", true);
    public InInt inStrength = new InInt("strength", "Center channel strength", 1, 1, 8);
    public OutSpectrum outAudio = new OutSpectrum("out", "Output audio spectrum");
    private Cmplx dummy = new Cmplx();
    private Cmplx[][] source;
    private Cmplx srcWest = new Cmplx();
    private Cmplx srcEast = new Cmplx();
    private Cmplx srcNorth = new Cmplx();
    private Cmplx srcSouth = new Cmplx();
    private Cmplx srcFront = new Cmplx();
    private Cmplx srcRear = new Cmplx();
    private Cmplx dstFront = new Cmplx();
    private Cmplx dstRear = new Cmplx();

    public StereoToQuad() {
        super("audio.effect.spectrum.channels.stereo2quad", "Decompose stereo sound into 4 channels (left, center, right, rear)");
        super.setSkillType(SkillType.ADVANCED);
        this.inSurround.setSkillType(SkillType.ADVANCED);
    }

    @Override
    public void cycle() {
        boolean surround = (Boolean)this.inSurround.read();
        int nbChannels = surround ? 4 : 3;
        SpectrumData inSpec = (SpectrumData)this.inAudio.read();
        int strength = (Integer)this.inStrength.read();
        this.outAudio.prepare(nbChannels * inSpec.nbLayers, inSpec.nbBins, inSpec.nbLayers, inSpec.hqxMode, inSpec.windowing);
        if (this.source == null || this.source.length != inSpec.audioChannels() || this.source[0].length != inSpec.nbBins) {
            this.source = Cmplx.newArray(inSpec.audioChannels(), inSpec.nbBins);
        }
        inSpec.fillSumByLayer(this.source);
        SpectrumData outSpec = (SpectrumData)this.outAudio.get();
        int nbLayers = inSpec.nbLayers;
        int layer = 0;
        while (layer < inSpec.nbLayers) {
            int src0 = nbLayers * 0 + layer;
            int src1 = (nbLayers * 1 + layer) % inSpec.nbChannels;
            int dst0 = nbLayers * 0 + layer;
            int dst1 = nbLayers * 1 + layer;
            int dst2 = nbLayers * 2 + layer;
            int dst3 = nbLayers * 3 + layer;
            int i = 0;
            while (i < inSpec.nbBins) {
                Cmplx dstWest = outSpec.data[dst0][i];
                Cmplx dstEast = outSpec.data[dst1][i];
                Cmplx dstNorth = outSpec.data[dst2][i];
                Cmplx dstSouth = surround ? outSpec.data[dst3][i] : this.dummy;
                this.srcWest.set(this.source[0][i]);
                this.srcEast.set(this.source[1][i]);
                this.srcNorth.clear();
                this.srcSouth.clear();
                dstWest.set(inSpec.data[src0][i]);
                dstEast.set(inSpec.data[src1][i]);
                dstNorth.clear();
                dstSouth.clear();
                int k = 0;
                while (k < strength) {
                    this.quadize(dstWest, dstEast, dstNorth, dstSouth, this.srcWest, this.srcEast, this.srcNorth, this.srcSouth, surround);
                    ++k;
                }
                ++i;
            }
            ++layer;
        }
    }

    private void quadize(Cmplx dstWest, Cmplx dstEast, Cmplx dstNorth, Cmplx dstSouth, Cmplx srcWest, Cmplx srcEast, Cmplx srcNorth, Cmplx srcSouth, boolean surround) {
        boolean isRear;
        this.srcFront.sum(srcWest, srcEast);
        this.srcRear.dif(srcWest, srcEast);
        this.dstFront.sum(dstWest, dstEast);
        this.dstRear.dif(dstWest, dstEast);
        float pmLeft = srcWest.powerMag();
        float pmRight = srcEast.powerMag();
        float pmFront = this.srcFront.powerMag();
        float pmRear = this.srcRear.powerMag();
        float pmCommon = pmLeft < pmRight ? pmLeft : pmRight;
        boolean bl = isRear = pmRear > pmFront;
        if (isRear) {
            if (surround) {
                if (pmRear > pmCommon) {
                    float correction = (float)Math.sqrt(pmCommon / pmRear);
                    this.srcRear.mul(correction);
                    this.dstRear.mul(correction);
                }
            } else {
                this.srcRear.clear();
                this.dstRear.clear();
            }
            this.srcFront.clear();
            this.dstFront.clear();
        } else {
            if (pmFront > pmCommon) {
                float correction = (float)Math.sqrt(pmCommon / pmFront);
                this.srcFront.mul(correction);
                this.dstFront.mul(correction);
            }
            this.srcRear.clear();
            this.dstRear.clear();
        }
        srcNorth.add(this.srcFront);
        srcWest.sub(this.srcFront);
        srcEast.sub(this.srcFront);
        dstNorth.add(this.dstFront);
        dstWest.sub(this.dstFront);
        dstEast.sub(this.dstFront);
        if (surround) {
            srcSouth.add(this.srcRear);
            srcWest.sub(this.srcRear);
            srcEast.add(this.srcRear);
            dstSouth.add(this.dstRear);
            dstWest.sub(this.dstRear);
            dstEast.add(this.dstRear);
        }
    }
}

