/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.filter;

import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.bouncelets.audio.base.AudioMonoSpectrumBouncelet;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;
import org.corebounce.decklight.ports.InInt;

public class Comb
extends AudioMonoSpectrumBouncelet {
    private static final int NOMINAL_SIZE = 2048;
    public InSpectrum inAudio = new InSpectrum("in", "Input audio spectrum");
    public InDouble inRatio = new InDouble("ratio", "Amount of bins to remove", 0.75, 0.0, 1.0);
    public InInt inPhase = new InInt("phase", "Phase", 0, 0, 1024);
    public OutSpectrum outAudio = new OutSpectrum("out", "Output audio spectrum");

    public Comb() {
        super("audio.effect.spectrum.filter.comb", "Remove a percentage of frequency bins", false);
        super.setSkillType(SkillType.ADVANCED);
        this.inRatio.setSkillType(SkillType.SIMPLIFIED);
        this.inPhase.setSkillType(SkillType.ADVANCED);
    }

    @Override
    public void process(Cmplx[] input, Cmplx[] output) {
        double removeFactor = (Double)this.inRatio.read();
        double correction = 1.0 / (1.0 - (removeFactor + 0.5) / 2.0);
        int phase = (Integer)this.inPhase.read();
        int fftSize = (input.length - 1) * 2;
        int packetSize = fftSize <= 2048 ? 1 : fftSize / 2048;
        output[0].set(input[0]);
        float skipIt = 0.0f;
        int pn = packetSize;
        boolean remove = true;
        int i = 1;
        while (i < output.length) {
            int index = (i - 1 + phase) % (output.length - 1) + 1;
            if (--pn <= 0) {
                skipIt = (float)((double)skipIt + removeFactor);
                pn = packetSize;
                if (skipIt >= 1.0f) {
                    skipIt -= 1.0f;
                    remove = true;
                } else {
                    remove = false;
                }
            }
            if (remove) {
                output[index].set(0.0f, 0.0f);
            } else {
                output[index].set(input[index]);
                output[i].mul((float)correction);
            }
            ++i;
        }
    }
}

