/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.filter;

import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.GraphErrorType;
import org.corebounce.decklight.bouncelets.audio.base.AudioMath;
import org.corebounce.decklight.bouncelets.audio.base.FrequenciesData;
import org.corebounce.decklight.bouncelets.audio.base.SpectrumData;
import org.corebounce.decklight.bouncelets.audio.ports.InFrequencies;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InBoolean;
import org.corebounce.decklight.ports.InDouble;
import org.corebounce.utils.Severity;

public class CrossSynth
extends Bouncelet {
    private static final float THRESHOLD = (float)AudioMath.dbToLevel(-120.0);
    private static final float MAX_CORRECTION = (float)AudioMath.dbToLevel(12.0);
    private static final float ACG_RATE = 4.3f;
    public InSpectrum inSpectrum = new InSpectrum("carrier", "Carrier tone");
    public InFrequencies inShape = new InFrequencies("modulator", "Filter to apply");
    public InDouble inWhitening = new InDouble("whitening", "Centroid displacement through whitening", 0.25, 0.0, 2.0);
    public InBoolean inAcg = new InBoolean("acg", "Auto Gain Control", true);
    public InDouble inBoost = new InDouble("boost", "Volumn boost [dB]", 0.0, -6.0, 12.0);
    public OutSpectrum outSpectrum = new OutSpectrum("out", "Output audio spectrum");
    private float whitening;
    private boolean acg;
    private float boost;
    private float fixRatio;
    private float[] corrections;

    public CrossSynth() {
        super("audio.effect.spectrum.filter.cross-synth", "Cross Synthesis");
        super.setSkillType(SkillType.ADVANCED);
        this.inWhitening.setSkillType(SkillType.SIMPLIFIED);
    }

    @Override
    public void cycle() {
        this.setup();
        this.process();
    }

    private void setup() {
        if (this.inWhitening.isModified()) {
            double value = (Double)this.inWhitening.read();
            this.whitening = value < 1.0 ? (float)(Math.pow(10.0, value) - 1.0) / 9.0f : (float)value;
        }
        if (this.inAcg.isModified()) {
            this.acg = (Boolean)this.inAcg.read();
        }
        if (this.inBoost.isModified()) {
            this.boost = (float)AudioMath.dbToLevel((Double)this.inBoost.read());
        }
    }

    private void process() {
        SpectrumData inData = (SpectrumData)this.inSpectrum.read();
        boolean changes = this.outSpectrum.prepare(inData);
        SpectrumData outData = (SpectrumData)this.outSpectrum.get();
        FrequenciesData shape = (FrequenciesData)this.inShape.read();
        if (changes) {
            this.corrections = new float[inData.nbChannels];
            this.fixRatio = (float)inData.getRealDuration() * 4.3f;
            if (this.fixRatio > 1.0f) {
                this.fixRatio = 1.0f;
            }
            if (inData.nbBins != shape.nbBins) {
                super.log(GraphErrorType.IllegalArgument, Severity.Error, "Spectrum has not the same size ({0}) as shape ({1})", inData.nbBins, shape.nbBins);
            }
            if (inData.nbChannels != shape.nbChannels) {
                super.log(GraphErrorType.IllegalArgument, Severity.Warning, "Spectrum has not the same number of channels ({0}) as shape ({1})", inData.nbChannels, shape.nbChannels);
            }
        }
        float fixup = (float)Math.sqrt(inData.getNbFrames());
        int chan = 0;
        while (chan < inData.nbChannels) {
            float[] curve = shape.data[chan % shape.nbChannels];
            Cmplx[] input = inData.data[chan];
            Cmplx[] output = outData.data[chan];
            assert (input.length == curve.length);
            float carEnergy = 0.0f;
            float modEnergy = 0.0f;
            float dstEnergy = 0.0f;
            int i = 0;
            while (i < input.length) {
                float inLevel = input[i].magApprox();
                float filter = curve[i];
                carEnergy += input[i].powerMag();
                modEnergy += filter * filter;
                if (inLevel < THRESHOLD) {
                    output[i].mul(filter * this.boost);
                } else {
                    float outLevel;
                    float outLevel1;
                    float outLevel0;
                    if ((double)this.whitening <= 1.0) {
                        outLevel0 = inLevel * filter * fixup;
                        outLevel1 = Math.min(inLevel, filter);
                        outLevel = outLevel0 * (1.0f - this.whitening) + outLevel1 * this.whitening;
                    } else {
                        outLevel0 = Math.min(inLevel, filter);
                        outLevel1 = filter;
                        outLevel = outLevel0 * (2.0f - this.whitening) + outLevel1 * (this.whitening - 1.0f);
                    }
                    float correction = outLevel * this.boost / inLevel;
                    if (correction > MAX_CORRECTION) {
                        correction = MAX_CORRECTION;
                    }
                    output[i].set(input[i].re * correction, input[i].im * correction);
                }
                dstEnergy += output[i].powerMag();
                ++i;
            }
            if (this.acg && dstEnergy > THRESHOLD) {
                float correction;
                float srcEnergy = Math.min(carEnergy, modEnergy);
                float newCorrection = (float)Math.sqrt(srcEnergy / dstEnergy);
                if (newCorrection > MAX_CORRECTION) {
                    newCorrection = MAX_CORRECTION;
                }
                if (newCorrection > this.corrections[chan] * 4.0f + 1.0f) {
                    newCorrection = this.corrections[chan] * 4.0f + 1.0f;
                }
                this.corrections[chan] = correction = this.corrections[chan] * (1.0f - this.fixRatio) + newCorrection * this.fixRatio;
                correction *= this.boost;
                int i2 = 0;
                while (i2 < output.length) {
                    output[i2].mul(correction);
                    ++i2;
                }
            }
            ++chan;
        }
    }
}

