/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.filter;

import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.GraphErrorType;
import org.corebounce.decklight.bouncelets.audio.base.FrequenciesData;
import org.corebounce.decklight.bouncelets.audio.base.SpectrumData;
import org.corebounce.decklight.bouncelets.audio.ports.InFrequencies;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.utils.Severity;

public class Filter
extends Bouncelet {
    public InSpectrum inSpectrum = new InSpectrum("in", "Input audio spectrum");
    public InFrequencies inShape = new InFrequencies("filter", "Filter to apply");
    public OutSpectrum outSpectrum = new OutSpectrum("out", "Output audio spectrum");

    public Filter() {
        super("audio.effect.spectrum.filter.filter", "Filter a sound using a spectral curve");
        super.setSkillType(SkillType.ADVANCED);
    }

    @Override
    public void cycle() {
        SpectrumData inData = (SpectrumData)this.inSpectrum.read();
        boolean changes = this.outSpectrum.prepare(inData);
        SpectrumData outData = (SpectrumData)this.outSpectrum.get();
        FrequenciesData shape = (FrequenciesData)this.inShape.read();
        if (changes) {
            if (inData.nbBins != shape.nbBins) {
                super.log(GraphErrorType.IllegalArgument, Severity.Error, "Spectrum has not the same size ({0}) as filter ({1})", inData.nbBins, shape.nbBins);
            }
            if (inData.nbChannels != shape.nbChannels) {
                super.log(GraphErrorType.IllegalArgument, Severity.Warning, "Spectrum has not the same number of channels ({0}) as filter ({1})", inData.nbChannels, shape.nbChannels);
            }
        }
        int chan = 0;
        while (chan < inData.nbChannels) {
            float srcEnergy = 0.0f;
            float dstEnergy = 0.0f;
            float[] curve = shape.data[chan % shape.nbChannels];
            Cmplx[] input = inData.data[chan];
            Cmplx[] output = outData.data[chan];
            if (input.length != output.length) {
                return;
            }
            int i = 0;
            while (i < input.length) {
                float filter = curve[i];
                srcEnergy += filter * filter;
                output[i].set(input[i].re * filter, input[i].im * filter);
                dstEnergy += output[i].powerMag();
                ++i;
            }
            if (dstEnergy > 0.0f) {
                float correction = (float)Math.sqrt(srcEnergy / dstEnergy);
                int i2 = 0;
                while (i2 < output.length) {
                    output[i2].mul(correction);
                    ++i2;
                }
            }
            ++chan;
        }
    }
}

