/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.filter;

import org.corebounce.common.dsp.fft.BooFFT;
import org.corebounce.common.dsp.fft.Windows;
import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;

public class FirEqualizerEngine {
    private static final int NB_BANDS = 10;
    private static final double[] frequencies = new double[]{86.0, 172.0, 345.0, 689.0, 1378.0, 2756.0, 5512.0, 8764.0, 13935.0};
    private final int length;
    private final float[] levels;
    private final BooFFT fft;
    private final Cmplx[][] kernels;
    private final Cmplx[] spectrum;
    private final Cmplx[] filter;
    private final float[] bufferIn;
    private final float[] bufferOut;
    private final Cmplx work = new Cmplx();
    private int mergeIndex = 0;

    public FirEqualizerEngine(int length) {
        this.length = length;
        this.levels = new float[10];
        this.fft = new BooFFT(length);
        this.kernels = Cmplx.newArray(10, length + 1);
        this.spectrum = Cmplx.newArray(length + 1);
        this.filter = Cmplx.newArray(length + 1);
        this.bufferIn = new float[length * 2];
        this.bufferOut = new float[length * 2];
        this.buildKernels();
    }

    private void buildKernels() {
        int nbBins = this.length / 2 + 1;
        Cmplx[] filter = Cmplx.newArray(nbBins);
        float[] response = new float[this.length];
        float[] centered = new float[this.length];
        float[] hann = new float[this.length];
        Windows.fillWindow(hann, this.length, Windows.HannCoefs);
        BooFFT hfft = new BooFFT(this.length / 2);
        double binSpace = (double)AudioConfig.getSampleRate() / (double)this.length;
        int startBin = 0;
        int stopBin = 0;
        int band = 0;
        while (band < 10) {
            startBin = stopBin;
            stopBin = band == 9 ? nbBins : (int)(frequencies[band] / binSpace + 0.5);
            int i = 0;
            while (i < nbBins) {
                if (i >= startBin && i < stopBin) {
                    filter[i].set(1.0f, 0.0f);
                } else {
                    filter[i].set(0.0f, 0.0f);
                }
                ++i;
            }
            hfft.backC2R(filter, response);
            i = 0;
            while (i < this.length) {
                centered[i] = response[(i + this.length / 2) % this.length];
                ++i;
            }
            i = 0;
            while (i < this.length) {
                int n = i;
                centered[n] = centered[n] * (hann[i] * 0.5f);
                ++i;
            }
            this.fft.forwR2CPadded(centered, this.kernels[band], 2);
            ++band;
        }
    }

    public void setLevels(float[] levels) {
        if (levels.length != 10) {
            throw new IllegalArgumentException();
        }
        System.arraycopy(levels, 0, this.levels, 0, 10);
        this.updateFilter();
    }

    private void updateFilter() {
        int i = 0;
        while (i < this.filter.length) {
            this.filter[i].set(0.0f, 0.0f);
            ++i;
        }
        int b = 0;
        while (b < 10) {
            int i2 = 0;
            while (i2 < this.spectrum.length) {
                this.work.set(this.kernels[b][i2]);
                this.work.mul(this.levels[b]);
                this.filter[i2].add(this.work);
                ++i2;
            }
            ++b;
        }
    }

    public void process(float[] input, float[] output) {
        this.fft.forwR2CPadded(input, this.spectrum, 2);
        int i = 0;
        while (i < this.spectrum.length) {
            this.spectrum[i].mul(this.filter[i]);
            ++i;
        }
        this.fft.backC2R(this.spectrum, this.bufferIn);
        int addIndex = this.mergeIndex;
        int setIndex = this.length - this.mergeIndex;
        int i2 = 0;
        while (i2 < this.length) {
            output[i2] = this.bufferOut[setIndex + i2];
            int n = addIndex + i2;
            this.bufferOut[n] = this.bufferOut[n] + this.bufferIn[i2];
            this.bufferOut[setIndex + i2] = this.bufferIn[i2 + this.length];
            ++i2;
        }
        this.mergeIndex = setIndex;
    }

    public int getSampleLatency() {
        return this.length;
    }
}

