/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.filter;

import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.base.AudioMonoSpectrumBouncelet;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;

public class HighFilter
extends AudioMonoSpectrumBouncelet {
    public InSpectrum inData = new InSpectrum("in", "Input audio spectrum");
    public InDouble inStrength = new InDouble("strength", "Strength: Volume(freq)=1/(freq/2^depth)^strength.", 1.0, 0.0, 4.0);
    public InDouble inDepth = new InDouble("depth", "Depth: Volume(freq)=1(freq/2^depth)^strength.", 10.0, 1.0, 50.0);
    public OutSpectrum outData = new OutSpectrum("out", "Output audio spectrum");
    private double strength;
    private double depth;

    public HighFilter() {
        super("audio.effect.spectrum.filter.highfilter", "Filter high frequencies", true);
        super.setSkillType(SkillType.ADVANCED);
    }

    @Override
    protected void setup() {
        if (this.inStrength.isModified()) {
            this.strength = (Double)this.inStrength.read();
        }
        if (this.inDepth.isModified()) {
            this.depth = Math.pow(2.0, (Double)this.inDepth.read());
        }
    }

    @Override
    public void process(Cmplx[] input, Cmplx[] output) {
        double binSize = (double)AudioConfig.getSampleRate() / (double)(input.length - 1);
        double scale = binSize / this.depth;
        output[0].set(input[0]);
        int i = 1;
        while (i < input.length) {
            double freq;
            double level;
            if (input != output) {
                output[i].set(input[i]);
            }
            if ((level = 1.0 / Math.pow(freq = (double)i * scale, this.strength)) > 1.0) {
                level = 1.0;
            }
            output[i].mul((float)level);
            ++i;
        }
    }
}

