/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.filter;

import java.util.BitSet;
import org.corebounce.common.math.Cmplx;
import org.corebounce.common.math.ShellSort;

public class MelodyExtractor {
    private final int nbBins;
    private final int maxNbPeaks;
    private final float separationRatio;
    private final float dominationRatio;
    private final int minBin;
    private final float[] powerMags;
    private final int[] peakBinNums;
    private final float[] peakMags;
    private final float[] peakSeparation;
    private int nbPeaks;
    private final int[] sortedIndexes;
    private final BitSet extractedBins;

    public MelodyExtractor(int nbBins, int maxNbPeaks, float separationRatio, float dominationRatio, int minBin) {
        this.nbBins = nbBins;
        this.maxNbPeaks = maxNbPeaks;
        this.separationRatio = separationRatio;
        this.dominationRatio = dominationRatio;
        this.minBin = minBin;
        this.powerMags = new float[nbBins];
        this.peakBinNums = new int[nbBins];
        this.peakMags = new float[nbBins];
        this.peakSeparation = new float[nbBins];
        this.sortedIndexes = new int[nbBins];
        this.extractedBins = new BitSet(nbBins);
    }

    public BitSet process(Cmplx[][] audio) {
        float avgMag = 0.0f;
        int i = 0;
        while (i < this.nbBins) {
            this.powerMags[i] = audio[0][i].powerMag();
            ++i;
        }
        int chan = 1;
        while (chan < audio.length) {
            int i2 = 0;
            while (i2 < this.nbBins) {
                int n = i2;
                this.powerMags[n] = this.powerMags[n] + audio[chan][i2].powerMag();
                ++i2;
            }
            ++chan;
        }
        i = 0;
        while (i < this.nbBins) {
            avgMag += this.powerMags[i];
            ++i;
        }
        avgMag /= (float)this.nbBins;
        this.nbPeaks = 0;
        i = this.minBin;
        while (i < this.nbBins) {
            float separation = this.getPeakSeparation(i, avgMag);
            if (separation > 0.0f) {
                this.peakBinNums[this.nbPeaks] = i;
                this.peakSeparation[this.nbPeaks] = separation;
                this.peakMags[this.nbPeaks] = this.getPowerMag(i);
                ++this.nbPeaks;
            }
            ++i;
        }
        i = 0;
        while (i < this.nbPeaks) {
            this.sortedIndexes[i] = i;
            ++i;
        }
        ShellSort.sort(this.sortedIndexes, this.peakSeparation, this.nbPeaks);
        int maxCount = Math.min(this.maxNbPeaks, this.nbPeaks);
        this.extractedBins.clear();
        int rank = 0;
        while (rank < maxCount) {
            int startBin;
            int peakNum = this.sortedIndexes[rank];
            int peakBin = this.peakBinNums[peakNum];
            float peakMag = this.peakMags[peakNum];
            int stopBin = startBin = peakBin;
            while (startBin > 0 && peakBin - startBin < 5 && peakMag > this.getPowerMag(startBin - 1)) {
                --startBin;
            }
            while (stopBin < this.nbBins - 1 && stopBin - peakBin < 5 && peakMag > this.getPowerMag(stopBin + 1)) {
                ++stopBin;
            }
            this.extractedBins.set(startBin, stopBin + 1);
            ++rank;
        }
        return this.extractedBins;
    }

    private float getPeakSeparation(int index, float avgMag) {
        float current = this.getPowerMag(index);
        float prev = this.getPowerMag(index - 1);
        float next = this.getPowerMag(index + 1);
        if (current <= prev || current < next) {
            return 0.0f;
        }
        if (current < avgMag * this.dominationRatio) {
            return 0.0f;
        }
        boolean prevOk = false;
        boolean nextOk = false;
        float result = 0.0f;
        int i = 1;
        while (i <= 7) {
            float magNext;
            float sepNext;
            float magPrev = this.getPowerMag(index - i);
            float sepPrev = current / magPrev;
            if (sepPrev > this.separationRatio) {
                prevOk = true;
                if (sepPrev > result) {
                    result = sepPrev;
                }
            }
            if ((sepNext = current / (magNext = this.getPowerMag(index + i))) > this.separationRatio) {
                nextOk = true;
                if (sepNext > result) {
                    result = sepPrev;
                }
            }
            ++i;
        }
        if (!prevOk || !nextOk) {
            return 0.0f;
        }
        return result;
    }

    private float getPowerMag(int index) {
        if (index < 0 || index >= this.powerMags.length) {
            return 0.0f;
        }
        return this.powerMags[index];
    }
}

