/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.filter;

import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.bouncelets.audio.base.AudioExtractSpectrumBouncelet;
import org.corebounce.decklight.bouncelets.audio.base.SpectrumData;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;
import org.corebounce.decklight.ports.InInt;

public class PeakPeek
extends AudioExtractSpectrumBouncelet {
    public InSpectrum inAudio = new InSpectrum("in", "Input audio spectrum");
    public InInt inAmount = new InInt("amount", "Number of peaks to extract", 10, 1, 60);
    public InDouble inHighBias = new InDouble("bias", "High frequencies bias", 1.0, 0.1, 10.0);
    public OutSpectrum outNoise = new OutSpectrum("noise", "Output audio floor (noise)");
    public OutSpectrum outMelody = new OutSpectrum("melody", "Output audio peaks (melody)");
    private float[] energies;
    private int amount;
    private double highBias;

    public PeakPeek() {
        super("audio.effect.spectrum.filter.peak-peek", "Extract peak frequencies");
        super.setSkillType(SkillType.ADVANCED);
        this.inHighBias.setScaleType(ScaleType.LOG2);
        this.inHighBias.setSkillType(SkillType.ADVANCED);
    }

    @Override
    protected OutSpectrum getOutput1() {
        return this.outNoise;
    }

    @Override
    protected OutSpectrum getOutput2() {
        return this.outMelody;
    }

    @Override
    protected void setup() {
        super.setup();
        if (this.inAmount.isModified()) {
            this.amount = (Integer)this.inAmount.read();
        }
        if (this.inHighBias.isModified()) {
            this.highBias = (Double)this.inHighBias.read();
        }
        SpectrumData spectrum = (SpectrumData)this.inAudio.peek();
        if (this.energies == null || this.energies.length != spectrum.nbBins) {
            this.energies = new float[spectrum.nbBins];
        }
    }

    @Override
    public void process(int chan, Cmplx[] input, Cmplx[] output1, Cmplx[] output2) {
        Cmplx[] source = super.currentSource();
        int i = 0;
        while (i < input.length) {
            output1[i].set(input[i]);
            output2[i].set(0.0f, 0.0f);
            ++i;
        }
        i = 0;
        while (i < source.length) {
            this.energies[i] = source[i].powerMag() * (float)Math.pow((double)i / (double)input.length, this.highBias);
            ++i;
        }
        int c = 0;
        while (c < this.amount) {
            int maxBin = 0;
            float maxEnergy = -1.0f;
            int i2 = 0;
            while (i2 < output1.length) {
                if (this.energies[i2] > maxEnergy) {
                    maxEnergy = this.energies[i2];
                    maxBin = i2;
                }
                ++i2;
            }
            int start = maxBin;
            int stop = maxBin;
            while (start > 0 && (this.energies[start - 1] < this.energies[start] || start > 1 && this.energies[start - 2] < this.energies[start])) {
                --start;
            }
            while (stop < input.length - 1 && (this.energies[stop + 1] < this.energies[stop] || stop < input.length - 2 && this.energies[stop + 2] < this.energies[stop])) {
                ++stop;
            }
            int i3 = start;
            while (i3 <= stop) {
                output2[i3].set(output1[i3]);
                output1[i3].set(0.0f, 0.0f);
                this.energies[i3] = 0.0f;
                ++i3;
            }
            ++c;
        }
    }
}

