/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.filter;

import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.bouncelets.audio.base.AudioMonoSpectrumBouncelet;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;

public class Rotate
extends AudioMonoSpectrumBouncelet {
    public InSpectrum inAudio = new InSpectrum("in", "Input audio spectrum");
    public InDouble inAngle = new InDouble("angle", "Rotation angle [2pi]", 0.25, 0.0, 1.0);
    public OutSpectrum outAudio = new OutSpectrum("out", "Output audio spectrum");
    private Cmplx phasor = new Cmplx();

    public Rotate() {
        super("audio.effect.spectrum.filter.rotate", "Phase rotation", true);
        super.setSkillType(SkillType.ADVANCED);
        this.inAngle.setSkillType(SkillType.SIMPLIFIED);
    }

    @Override
    protected void setup() {
        super.setup();
        if (this.inAngle.isModified()) {
            double angle = (Double)this.inAngle.read() * Math.PI * 2.0;
            this.phasor.set((float)Math.cos(angle), (float)Math.sin(angle));
        }
    }

    @Override
    public void process(Cmplx[] input, Cmplx[] output) {
        int i;
        if (input.length != output.length) {
            throw new IllegalArgumentException();
        }
        if (input != output) {
            i = 0;
            while (i < input.length) {
                output[i].set(input[i]);
                ++i;
            }
        }
        i = 0;
        while (i < input.length) {
            output[i].mul(this.phasor);
            ++i;
        }
    }
}

