/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.filter;

import java.util.BitSet;
import org.corebounce.common.dsp.AverageBuffer;
import org.corebounce.common.math.Cmplx;
import org.corebounce.common.math.FastMath;

public class ShitExtractEngine {
    final int nbBins;
    final int length;
    private final float[] lastAngles;
    private final float[] lastFreq;
    private final AverageBuffer[] averages;
    private final AverageBuffer[] variances;
    private final BitSet isShit;

    public ShitExtractEngine(int nbBins, int length) {
        this.nbBins = nbBins;
        this.length = length;
        this.lastAngles = new float[nbBins];
        this.lastFreq = new float[nbBins];
        this.averages = new AverageBuffer[nbBins];
        int i = 0;
        while (i < nbBins) {
            this.averages[i] = new AverageBuffer(length);
            ++i;
        }
        this.variances = new AverageBuffer[nbBins];
        i = 0;
        while (i < nbBins) {
            this.variances[i] = new AverageBuffer(length);
            ++i;
        }
        this.isShit = new BitSet(nbBins);
    }

    public void analyze(Cmplx[] spectrum, float threshold) {
        if (spectrum.length != this.nbBins) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < this.nbBins) {
            float angle = spectrum[i].phi();
            float prev = this.lastAngles[i];
            this.lastAngles[i] = angle;
            float freq = (float)FastMath.wrap(angle - prev);
            prev = this.lastFreq[i];
            this.lastFreq[i] = freq;
            float diff = Math.abs((float)FastMath.wrap(freq - prev));
            this.averages[i].push(diff);
            float avg = this.averages[i].getAverage();
            float variation = Math.abs(diff - avg);
            this.variances[i].push(variation);
            float variance = this.variances[i].getAverage();
            this.isShit.set(i, variance > threshold);
            ++i;
        }
    }

    public void process(Cmplx[] spectrum, Cmplx[] food, Cmplx[] shit) {
        int i = 0;
        while (i < this.nbBins) {
            if (this.isShit.get(i)) {
                food[i].set(0.0f, 0.0f);
                shit[i].set(spectrum[i]);
            } else {
                food[i].set(spectrum[i]);
                shit[i].set(0.0f, 0.0f);
            }
            ++i;
        }
    }
}

