/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.filter;

import java.util.Arrays;
import java.util.BitSet;
import org.corebounce.common.dsp.fft.BooFFT;
import org.corebounce.common.dsp.fft.Windows;
import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.InPowerOf2;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.SkillType;

public class TranxBase
extends Bouncelet {
    public InAudio inAudio = new InAudio("in", "Input audio wave");
    public InPowerOf2 inBlockSize0 = new InPowerOf2(true, "blockSize0", "FFT Size 0", PowerOf2.p1024);
    public InPowerOf2 inBlockSize1 = new InPowerOf2(true, "blockSize1", "FFT Size 1", PowerOf2.p4096);
    public OutAudio outAudio0 = new OutAudio("out0", "Out 0");
    public OutAudio outAudio1 = new OutAudio("out1", "Out 1");
    private int blockSize;
    private int shiftSize;
    private int nbChans;
    private float[] srcBuffer;
    private float[][] inBuffer;
    private int inIndex;
    private float[] block;
    private float[] window0;
    private float[] window1;
    private BooFFT fft;
    private Cmplx[] spectrum0;
    private Cmplx[] spectrum1;
    private BitSet transients;
    private float[] result0;
    private float[] result1;
    private float[] invWindow;
    private float[][] outBuffer0;
    private float[][] outBuffer1;
    private int outIndex;

    public TranxBase() {
        super("audio.effect.spectrum.filter.tranx-base", "(Internal)");
        super.setSkillType(SkillType.EXPERT);
        this.inBlockSize0.setSkillType(SkillType.ADVANCED);
        this.inBlockSize1.setSkillType(SkillType.ADVANCED);
    }

    @Override
    public void cycle() {
        this.setup();
        this.process();
    }

    private void setup() {
        WaveData wave = (WaveData)this.inAudio.peek();
        if (wave.nbFrames != this.shiftSize || wave.nbChannels != this.nbChans || this.inBlockSize0.isModified() || this.inBlockSize1.isModified()) {
            int b1;
            this.shiftSize = wave.nbFrames;
            this.nbChans = wave.nbChannels;
            int b0 = ((PowerOf2)((Object)this.inBlockSize0.read())).intValue();
            this.blockSize = b0 > (b1 = ((PowerOf2)((Object)this.inBlockSize1.read())).intValue()) ? b0 : b1;
            int shrink0 = b0 > b1 ? 1 : b1 / b0;
            int shrink1 = b0 > b1 ? b0 / b1 : 1;
            this.srcBuffer = new float[this.blockSize];
            this.inBuffer = new float[this.nbChans][this.blockSize];
            this.inIndex = 0;
            this.block = new float[this.blockSize];
            this.window0 = new float[this.blockSize];
            this.window1 = new float[this.blockSize];
            Windows.fillShrunkWindow(this.window0, Windows.HannCoefs, shrink0);
            Windows.fillShrunkWindow(this.window1, Windows.HannCoefs, shrink1);
            this.fft = new BooFFT(this.blockSize / 2);
            int nbBins = this.blockSize / 2 + 1;
            this.spectrum0 = Cmplx.newArray(nbBins);
            this.spectrum1 = Cmplx.newArray(nbBins);
            this.transients = new BitSet(nbBins);
            this.result0 = new float[this.blockSize];
            this.result1 = new float[this.blockSize];
            this.invWindow = new float[this.shiftSize];
            float[] hann = new float[this.blockSize];
            Windows.fillWindow(hann, this.blockSize, Windows.HannCoefs);
            Windows.fillInverseWindow(this.window0, hann, this.invWindow, this.blockSize, this.shiftSize);
            this.outBuffer0 = new float[this.nbChans][this.blockSize];
            this.outBuffer1 = new float[this.nbChans][this.blockSize];
            this.outIndex = 0;
        }
    }

    private void process() {
        WaveData inWave = (WaveData)this.inAudio.read();
        this.outAudio0.prepare(inWave.nbChannels, inWave.nbFrames, inWave.windowing);
        this.outAudio1.prepare(inWave.nbChannels, inWave.nbFrames, inWave.windowing);
        WaveData outWave0 = (WaveData)this.outAudio0.get();
        WaveData outWave1 = (WaveData)this.outAudio1.get();
        assert (inWave.nbFrames == this.shiftSize);
        Arrays.fill(this.srcBuffer, this.inIndex, this.inIndex + this.shiftSize, 0.0f);
        int chan = 0;
        while (chan < inWave.nbChannels) {
            float[] input = inWave.data[chan];
            int i = 0;
            while (i < this.shiftSize) {
                int n = this.inIndex + i;
                this.srcBuffer[n] = this.srcBuffer[n] + input[i];
                this.inBuffer[chan][this.inIndex + i] = input[i];
                ++i;
            }
            ++chan;
        }
        this.inIndex = (this.inIndex + this.shiftSize) % this.blockSize;
        int i = 0;
        while (i < this.blockSize) {
            this.block[i] = this.srcBuffer[(i + this.inIndex) % this.blockSize] * this.window0[i];
            ++i;
        }
        this.fft.forwR2C(this.block, this.spectrum0);
        i = 0;
        while (i < this.blockSize) {
            this.block[i] = this.srcBuffer[(i + this.inIndex) % this.blockSize] * this.window1[i];
            ++i;
        }
        this.fft.forwR2C(this.block, this.spectrum1);
        i = 0;
        while (i < this.spectrum0.length) {
            float e1;
            float e0 = this.spectrum0[i].powerMag();
            this.transients.set(i, e0 > (e1 = this.spectrum1[i].powerMag()));
            ++i;
        }
        chan = 0;
        while (chan < this.nbChans) {
            int i2 = 0;
            while (i2 < this.blockSize) {
                this.block[i2] = this.inBuffer[chan][(i2 + this.inIndex) % this.blockSize] * this.window0[i2];
                ++i2;
            }
            this.fft.forwR2C(this.block, this.spectrum0);
            i2 = 0;
            while (i2 < this.spectrum0.length) {
                if (!this.transients.get(i2)) {
                    this.spectrum1[i2].set(this.spectrum0[i2]);
                    this.spectrum0[i2].clear();
                } else {
                    this.spectrum1[i2].clear();
                }
                ++i2;
            }
            Windows.convolveHann(this.spectrum0);
            this.fft.backC2R(this.spectrum0, this.result0);
            Windows.convolveHann(this.spectrum1);
            this.fft.backC2R(this.spectrum1, this.result1);
            i2 = 0;
            while (i2 < this.blockSize - this.shiftSize) {
                float[] fArray = this.outBuffer0[chan];
                int n = (i2 + this.outIndex) % this.blockSize;
                fArray[n] = fArray[n] + this.result0[i2];
                float[] fArray2 = this.outBuffer1[chan];
                int n2 = (i2 + this.outIndex) % this.blockSize;
                fArray2[n2] = fArray2[n2] + this.result1[i2];
                ++i2;
            }
            i2 = this.blockSize - this.shiftSize;
            while (i2 < this.blockSize) {
                this.outBuffer0[chan][(i2 + this.outIndex) % this.blockSize] = this.result0[i2];
                this.outBuffer1[chan][(i2 + this.outIndex) % this.blockSize] = this.result1[i2];
                ++i2;
            }
            float[] output0 = outWave0.data[chan];
            float[] output1 = outWave1.data[chan];
            int i3 = 0;
            while (i3 < this.shiftSize) {
                output0[i3] = this.outBuffer0[chan][i3 + this.outIndex] * this.invWindow[i3];
                output1[i3] = this.outBuffer1[chan][i3 + this.outIndex] * this.invWindow[i3];
                ++i3;
            }
            ++chan;
        }
        this.outIndex = (this.outIndex + this.shiftSize) % this.blockSize;
    }
}

