/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.noise;

import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.bouncelets.audio.base.AudioMath;
import org.corebounce.decklight.bouncelets.audio.base.AudioStateSpectrumBouncelet;
import org.corebounce.decklight.bouncelets.audio.base.SpectrumData;
import org.corebounce.decklight.bouncelets.audio.effect.spectrum.noise.BlindNoiseRemovalSpectrumEngine;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.ports.InDouble;
import org.corebounce.decklight.ports.InputPort;

public class BlindNoiseRemoval
extends AudioStateSpectrumBouncelet<BlindNoiseRemovalSpectrumEngine> {
    public InSpectrum inAudio = new InSpectrum("in", "Input audio spectrum");
    public InputPort<Mode> inMode = new InputPort<Mode>(Mode.class, "mode", "Analyze / Process", Mode.ANALYZE);
    public InDouble inNoisePeriod = new InDouble("noise-period", "Noise period [s]", 1.0, 0.01, 10.0);
    public InDouble inIgnoreDuration = new InDouble("ignore-duration", "Total duration of noise-free signal [s]", 0.2, 0.0, 30.0);
    public InDouble inBias = new InDouble("bias", "Noise reduction bias [dB]", 0.0, -10.0, 40.0);
    public OutSpectrum outAudio = new OutSpectrum("out", "Output audio spectrum");

    public BlindNoiseRemoval() {
        super("audio.effect.spectrum.amplitude.noise.noise-removal.nr-blind", "Noise Removal with blind pre-analysis (on signal+noise fragments)", true);
        this.inNoisePeriod.setScaleType(ScaleType.LOG2);
        this.inIgnoreDuration.setScaleType(ScaleType.CUBEROOT);
    }

    @Override
    public boolean checkForChanges() {
        return this.inMode.isModified() || this.inNoisePeriod.isModified() || this.inIgnoreDuration.isModified();
    }

    protected BlindNoiseRemovalSpectrumEngine[] createStates(int nbChans) {
        this.inMode.read();
        SpectrumData input = (SpectrumData)this.inAudio.peek();
        double blockDuration = input.getRealDuration();
        double noiseDuration = (Double)this.inNoisePeriod.read();
        double skipDuration = (Double)this.inIgnoreDuration.read();
        int noisePeriod = (int)(noiseDuration / blockDuration + 0.5);
        if (noisePeriod < 1) {
            noisePeriod = 1;
        }
        int nbSkip = (int)(skipDuration / blockDuration + 0.5);
        System.out.println("noisePeriod: " + noisePeriod + ", nbSkip: " + nbSkip);
        BlindNoiseRemovalSpectrumEngine[] result = new BlindNoiseRemovalSpectrumEngine[nbChans];
        int c = 0;
        while (c < nbChans) {
            result[c] = new BlindNoiseRemovalSpectrumEngine(input.nbBins, noisePeriod, nbSkip + 1);
            ++c;
        }
        return result;
    }

    @Override
    public void process(BlindNoiseRemovalSpectrumEngine state, int chan, Cmplx[] input, Cmplx[] output) {
        double threshold = AudioMath.dbToPowerLevel(-100.0);
        int i = 0;
        while (i < input.length) {
            float rndLevel;
            float cstLevel;
            float subLevel;
            float level = input[i].mag();
            if (level > 0.0f) {
                state.push(i, level);
            }
            if (level <= (subLevel = ((cstLevel = state.getCstFloor(i)) + (rndLevel = state.getRndFloor(i))) / 2.0f) || level <= rndLevel) {
                output[i].set(0.0f, 0.0f);
            } else if ((double)level > threshold) {
                double ratio = (level - subLevel) / level;
                output[i].set(input[i].re * (float)ratio, input[i].im * (float)ratio);
            } else if (input != output) {
                output[i].set(input[i]);
            }
            ++i;
        }
    }

    public static enum Mode {
        ANALYZE,
        PROCESS;

    }
}

