/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.noise;

import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.bouncelets.audio.base.AudioMath;
import org.corebounce.decklight.bouncelets.audio.base.AudioStateSpectrumBouncelet;
import org.corebounce.decklight.bouncelets.audio.base.SpectrumData;
import org.corebounce.decklight.bouncelets.audio.effect.spectrum.noise.NoiseSpectrumEngine;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InBoolean;
import org.corebounce.decklight.ports.InDouble;
import org.corebounce.decklight.ports.InInt;

public class NoiseFilter
extends AudioStateSpectrumBouncelet<NoiseSpectrumEngine> {
    public InSpectrum inAudio = new InSpectrum("in", "Input audio spectrum");
    public InDouble inContinuous = new InDouble("duration.cont", "Analysis block duration for continuous noise [s]", 6.0, 0.01, 60.0);
    public InDouble inRandom = new InDouble("duration.rnd", "Analysis block duration for random noise [s]", 0.2, 0.01, 1.0);
    public InInt inPeriods = new InInt("periods", "Number of periods for random noise", 15, 2, 200);
    public InDouble inMaxLevel = new InDouble("maxlevel", "Maximum noise level (relative to peak) [dB]", -20.0, -100.0, 20.0);
    public InDouble inBias = new InDouble("bias", "Bias level [dB]", 0.0, -10.0, 10.0);
    public InDouble inGap = new InDouble("gap", "Reactivation gap width [dB]", 5.0, 0.0, 10.0);
    public InDouble inDecay = new InDouble("smooth.decay", "Decay rate smoothing [dB/s]", 40.0, 2.0, 500.0);
    public InDouble inAttack = new InDouble("smooth.attack", "Attack rate smoothing [dB/s]", 150.0, 10.0, 2000.0);
    public InDouble inBeat = new InDouble("smooth.beat", "Unsmoothed beat threshold [dB]", 30.0, 0.0, 100.0);
    public InBoolean inLocked = new InBoolean("locked", "Lock current noise profile", false);
    public OutSpectrum outAudio = new OutSpectrum("out", "Output audio spectrum");
    private int nbBins = 0;
    private double beatFactor;
    private double attackFactor;
    private double decayFactor;
    private double peakDecayFactor;

    public NoiseFilter() {
        super("audio.effect.spectrum.amplitude.noise.noise-filter", "Active noise detection & filter", true);
        super.setSkillType(SkillType.ADVANCED);
        this.inContinuous.setScaleType(ScaleType.LOG2);
        this.inRandom.setScaleType(ScaleType.LOG2);
        this.inMaxLevel.setSkillType(SkillType.SIMPLIFIED);
        this.inBias.setSkillType(SkillType.NORMAL);
        this.inContinuous.setSkillType(SkillType.ADVANCED);
        this.inRandom.setSkillType(SkillType.ADVANCED);
        this.inPeriods.setSkillType(SkillType.ADVANCED);
        this.inGap.setSkillType(SkillType.ADVANCED);
        this.inDecay.setSkillType(SkillType.ADVANCED);
        this.inAttack.setSkillType(SkillType.ADVANCED);
        this.inBeat.setSkillType(SkillType.ADVANCED);
        this.inLocked.setSkillType(SkillType.ADVANCED);
    }

    @Override
    public boolean checkForChanges() {
        SpectrumData input = (SpectrumData)this.inAudio.peek();
        return input.nbBins != this.nbBins || this.inContinuous.isModified() || this.inRandom.isModified() || this.inPeriods.isModified() || this.inBeat.isModified() || this.inAttack.isModified() || this.inDecay.isModified();
    }

    protected NoiseSpectrumEngine[] createStates(int nbChans) {
        NoiseSpectrumEngine[] result;
        int minSize;
        SpectrumData input = (SpectrumData)this.inAudio.peek();
        this.nbBins = input.nbBins;
        double windowDuration = input.getRealDuration();
        if (this.inAttack.isModified()) {
            this.attackFactor = AudioMath.dbToPowerLevel((Double)this.inAttack.read() * windowDuration);
        }
        if (this.inDecay.isModified()) {
            this.decayFactor = 1.0 / AudioMath.dbToPowerLevel((Double)this.inDecay.read() * windowDuration);
        }
        if (this.inBeat.isModified()) {
            this.beatFactor = AudioMath.dbToLevel((Double)this.inBeat.read());
        }
        this.peakDecayFactor = 1.0 / AudioMath.dbToPowerLevel(5.0 * windowDuration);
        int maxSize = (int)((Double)this.inRandom.read() / windowDuration + 0.5);
        if (maxSize < 1) {
            maxSize = 1;
        }
        if ((minSize = (Integer)this.inPeriods.read() * input.windowing.getOverlapping().intValue()) < 2) {
            minSize = 2;
        }
        int cstSize = (int)((Double)this.inContinuous.read() / windowDuration + 0.5);
        System.out.println("maxSize: " + maxSize + "; minSize: " + minSize + "; cstSize: " + cstSize);
        System.out.println("Decay factor: " + Math.sqrt(this.decayFactor));
        if (this.states != null && ((NoiseSpectrumEngine[])this.states).length == nbChans) {
            result = (NoiseSpectrumEngine[])this.states;
            int i = 0;
            while (i < nbChans) {
                result[i].setSizes(this.nbBins, maxSize, minSize, cstSize);
                ++i;
            }
        } else {
            result = new NoiseSpectrumEngine[nbChans];
            int i = 0;
            while (i < nbChans) {
                result[i] = new NoiseSpectrumEngine(this.nbBins, maxSize, minSize, cstSize);
                ++i;
            }
        }
        return result;
    }

    @Override
    public void process(NoiseSpectrumEngine state, int chan, Cmplx[] input, Cmplx[] output) {
        assert (input.length == output.length);
        double gapRatio = AudioMath.dbToPowerLevel((Double)this.inGap.read());
        double biasRatio = AudioMath.dbToPowerLevel((Double)this.inBias.read());
        boolean isLocked = (Boolean)this.inLocked.read();
        double threshold = AudioMath.dbToPowerLevel(-100.0);
        float[] history = state.getHistory();
        double peakLevel = isLocked ? state.getPeak() : state.readPeak(this.peakDecayFactor);
        double maxNoiseLevel = peakLevel * AudioMath.dbToPowerLevel((Double)this.inMaxLevel.read());
        int i = 0;
        while (i < input.length) {
            double level = input[i].powerMag();
            double prev = history[i];
            if (prev < threshold) {
                prev = threshold;
            }
            if (!isLocked) {
                state.push(i, level);
            }
            double lowerLevel = state.getLowerLevel(i);
            double upperLevel = state.getUpperLevel(i);
            double beatLevel = upperLevel * this.beatFactor;
            if (level < prev * this.decayFactor) {
                level = prev * this.decayFactor;
            } else if (level > prev * this.attackFactor && level < beatLevel) {
                level = prev * this.attackFactor;
            }
            if (prev < upperLevel) {
                upperLevel *= gapRatio;
            }
            lowerLevel *= biasRatio;
            if ((upperLevel *= biasRatio) > maxNoiseLevel) {
                upperLevel = threshold;
            }
            if (lowerLevel > maxNoiseLevel) {
                lowerLevel = threshold;
            }
            if (upperLevel > lowerLevel) {
                lowerLevel = (lowerLevel + upperLevel) / 2.0;
            }
            history[i] = (float)level;
            if (level < upperLevel || level < lowerLevel) {
                output[i].set(0.0f, 0.0f);
            } else if (level > threshold) {
                double sqLevel = Math.sqrt(level);
                double ratio = (sqLevel - Math.sqrt(lowerLevel)) / sqLevel;
                output[i].set(input[i].re * (float)ratio, input[i].im * (float)ratio);
            }
            ++i;
        }
    }
}

