/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.noise;

import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.bouncelets.audio.base.AudioMath;
import org.corebounce.decklight.bouncelets.audio.base.AudioMonoSpectrumBouncelet;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InBoolean;
import org.corebounce.decklight.ports.InDouble;

public class NoiseReducer
extends AudioMonoSpectrumBouncelet {
    public InSpectrum inSpectrum = new InSpectrum("in", "Input Spectrum");
    public InDouble inReduction = new InDouble("threshold", "Noise reduction threshold [db]", -50.0, -100.0, 0.0);
    public InBoolean inApproximate = new InBoolean("approximate", "Use fast approximations", true);
    public InBoolean inReverse = new InBoolean("reverse", "Enhance noise instead of reducing", false);
    public OutSpectrum outSpectrum = new OutSpectrum("out", "Output Spectrum");
    private double reduction = 0.0;
    private boolean reverse = false;

    public NoiseReducer() {
        super("audio.effect.spectrum.amplitude.noise.noise-reducer", "Shift down frequency amplitudes", true);
        super.setSkillType(SkillType.ADVANCED);
        this.inReduction.setSkillType(SkillType.SIMPLIFIED);
        this.inApproximate.setSkillType(SkillType.ADVANCED);
    }

    @Override
    protected void setup() {
        if (this.inReduction.isModified()) {
            this.reduction = AudioMath.dbToLevel((Double)this.inReduction.read());
        }
        if (this.inReverse.isModified()) {
            this.reverse = (Boolean)this.inReverse.read();
        }
    }

    @Override
    public void process(Cmplx[] input, Cmplx[] output) {
        assert (input.length == output.length);
        boolean approx = (Boolean)this.inApproximate.read();
        output[0].set(input[0]);
        Cmplx[] source = super.currentSource();
        if (this.reverse) {
            float threshold = (float)AudioMath.dbToLevel(-90.0);
            int i = 1;
            while (i < input.length) {
                double mag = approx ? source[i].magApprox() : source[i].mag();
                if (mag > (double)threshold) {
                    double factor = (mag + this.reduction) / mag;
                    if (input != output) {
                        output[i].set(input[i]);
                    }
                    output[i].mul((float)factor);
                }
                ++i;
            }
        } else {
            int i = 1;
            while (i < input.length) {
                double mag = approx ? source[i].magApprox() : source[i].mag();
                if (mag < this.reduction) {
                    output[i].set(0.0f, 0.0f);
                } else {
                    double factor = (mag - this.reduction) / mag;
                    if (input != output) {
                        output[i].set(input[i]);
                    }
                    output[i].mul((float)factor);
                }
                ++i;
            }
        }
    }
}

