/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.noise;

import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.AudioMath;
import org.corebounce.decklight.bouncelets.audio.base.SpectrumData;
import org.corebounce.decklight.bouncelets.audio.effect.spectrum.noise.ProfiledNoiseRemovalEngine;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InBoolean;
import org.corebounce.decklight.ports.InDouble;
import org.corebounce.decklight.ports.InputPort;

public class ProfiledNoiseRemoval
extends Bouncelet {
    public InSpectrum inAudio = new InSpectrum("in", "Input audio spectrum");
    public InputPort<Mode> inMode = new InputPort<Mode>(Mode.class, "mode", "Analyze / Process", Mode.START_ANALYZE);
    public InDouble inBalance = new InDouble("balance", "Balance between cutting and subtracting", 0.5, 0.0, 1.0);
    public InDouble inBias = new InDouble("bias", "Noise reduction bias [dB]", 0.0, -10.0, 40.0);
    public InBoolean inContinuousOnly = new InBoolean("continuous-only", "Only remove continuous (non stochastic) noise", false);
    public InBoolean inNoiseOutput = new InBoolean("noise-output", "Output noise only instead of denoised signal", false);
    public OutSpectrum outDenoised = new OutSpectrum("out", "Denoised output audio spectrum");
    private int nbChans = -1;
    private int nbBins = -1;
    private ProfiledNoiseRemovalEngine[] engines = null;
    private Mode mode = null;
    private float balance;
    private boolean continuousOnly;
    private boolean noiseOutput;
    private static ProfiledNoiseRemovalEngine[] lastAnalysis = null;

    public ProfiledNoiseRemoval() {
        super("audio.effect.spectrum.amplitude.noise.noise-removal.nr-profiled", "Noise Removal with profiled pre-analysis (on noise-only fragments)", false);
        this.inContinuousOnly.setSkillType(SkillType.ADVANCED);
    }

    @Override
    public void cycle() {
        this.setup();
        this.process();
    }

    private void setup() {
        int n;
        int n2;
        ProfiledNoiseRemovalEngine[] profiledNoiseRemovalEngineArray;
        boolean changes = false;
        SpectrumData spectrum = (SpectrumData)this.inAudio.peek();
        if (spectrum.nbBins != this.nbBins || spectrum.nbChannels != this.nbChans) {
            changes = true;
        }
        if (changes) {
            this.nbBins = spectrum.nbBins;
            this.nbChans = spectrum.nbChannels;
            if (lastAnalysis != null && lastAnalysis.length == this.nbChans && lastAnalysis[0].getNbBins() == this.nbBins) {
                this.engines = lastAnalysis;
            } else {
                this.engines = new ProfiledNoiseRemovalEngine[this.nbChans];
                int i = 0;
                while (i < this.nbChans) {
                    this.engines[i] = new ProfiledNoiseRemovalEngine(this.nbBins, spectrum.windowing.getOverlapping().intValue() - 1);
                    ++i;
                }
                lastAnalysis = this.engines;
            }
        }
        if (this.inContinuousOnly.isModified() || this.inBalance.isModified()) {
            this.continuousOnly = (Boolean)this.inContinuousOnly.read();
            this.balance = (float)((Double)this.inBalance.read()).doubleValue();
            this.mode = this.inMode.peek();
            if (this.mode == Mode.PROCESS) {
                profiledNoiseRemovalEngineArray = this.engines;
                n2 = this.engines.length;
                n = 0;
                while (n < n2) {
                    ProfiledNoiseRemovalEngine engine = profiledNoiseRemovalEngineArray[n];
                    engine.startProcessing(this.continuousOnly, this.balance);
                    ++n;
                }
            }
        }
        if (this.inMode.isModified()) {
            this.mode = this.inMode.read();
            profiledNoiseRemovalEngineArray = this.engines;
            n2 = this.engines.length;
            n = 0;
            while (n < n2) {
                ProfiledNoiseRemovalEngine engine = profiledNoiseRemovalEngineArray[n];
                if (this.mode == Mode.START_ANALYZE) {
                    engine.startAnalysis();
                } else if (this.mode == Mode.CONTINUE_ANALYZE) {
                    engine.continueAnalysis();
                } else if (this.mode == Mode.PROCESS) {
                    engine.startProcessing(this.continuousOnly, this.balance);
                }
                ++n;
            }
        }
        if (this.inBias.isModified()) {
            double biasDb = (Double)this.inBias.read();
            float biasFactor = (float)AudioMath.dbToPowerLevel(biasDb);
            ProfiledNoiseRemovalEngine[] profiledNoiseRemovalEngineArray2 = this.engines;
            int n3 = this.engines.length;
            int n4 = 0;
            while (n4 < n3) {
                ProfiledNoiseRemovalEngine engine = profiledNoiseRemovalEngineArray2[n4];
                engine.setBiasFactor(biasFactor);
                ++n4;
            }
        }
        if (this.inNoiseOutput.isModified()) {
            this.noiseOutput = (Boolean)this.inNoiseOutput.read();
        }
    }

    private void process() {
        SpectrumData inSpectrum = (SpectrumData)this.inAudio.read();
        this.outDenoised.prepare(inSpectrum);
        SpectrumData outSpectrum = (SpectrumData)this.outDenoised.get();
        int chan = 0;
        while (chan < this.nbChans) {
            int i;
            ProfiledNoiseRemovalEngine engine = this.engines[chan];
            Cmplx[] input = inSpectrum.data[chan];
            Cmplx[] output = outSpectrum.data[chan];
            if (this.mode == Mode.START_ANALYZE || this.mode == Mode.CONTINUE_ANALYZE) {
                engine.analyze(input);
                if (input != output) {
                    i = 0;
                    while (i < input.length) {
                        output[i].set(input[i]);
                        ++i;
                    }
                }
            } else if (this.mode == Mode.PROCESS) {
                engine.process(input, output);
                if (this.noiseOutput) {
                    i = 0;
                    while (i < this.nbBins) {
                        output[i].dif(input[i], output[i]);
                        ++i;
                    }
                }
            }
            ++chan;
        }
    }

    public static enum Mode {
        START_ANALYZE,
        CONTINUE_ANALYZE,
        PROCESS;

    }
}

