/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.pitch;

import org.corebounce.decklight.BounceletBase;
import org.corebounce.decklight.bouncelets.audio.analysis.Formants;
import org.corebounce.decklight.bouncelets.audio.effect.spectrum.filter.Filter;
import org.corebounce.decklight.bouncelets.audio.effect.spectrum.shape.ShapeMorph;
import org.corebounce.decklight.bouncelets.audio.effect.spectrum.shape.ShapeShifter;
import org.corebounce.decklight.bouncelets.audio.flow.SpectrumPipe;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.macro.Connector;
import org.corebounce.decklight.macro.MacroBouncelet;
import org.corebounce.decklight.ports.InDouble;
import org.corebounce.decklight.ports.InputPort;
import org.corebounce.decklight.ports.OutputPort;

public class ChipMunk
extends MacroBouncelet {
    private final SpectrumPipe pipe = new SpectrumPipe();
    private final Formants formants = new Formants();
    private final ShapeShifter shapeShifter = new ShapeShifter();
    private final ShapeMorph shapeMorph = new ShapeMorph();
    private final Filter filter = new Filter();
    private final BounceletBase[] parts = new BounceletBase[]{this.pipe, this.formants, this.shapeShifter, this.shapeMorph, this.filter};

    public ChipMunk() {
        super("audio.effect.spectrum.pitch.chipmunk", "Shift the formants");
        super.setSkillType(SkillType.ADVANCED);
    }

    public InSpectrum getInSpectrum() {
        return this.pipe.inSpectrum;
    }

    public OutSpectrum getOutSpectrum() {
        return this.filter.outSpectrum;
    }

    public InDouble getInRatio() {
        return this.shapeShifter.inShiftRatio;
    }

    public InDouble getInDecayFreq() {
        return this.formants.inDecayFreq;
    }

    public InDouble getInThreshold() {
        return this.shapeMorph.inThreshold;
    }

    @Override
    public void createInternalConnections(Connector connector) {
        connector.connect(this.pipe.outSpectrum, this.formants.inSpectrum);
        connector.connect(this.formants.outShape, this.shapeShifter.inFreqs);
        connector.connect(this.formants.outShape, this.shapeMorph.inFreqs1);
        connector.connect(this.shapeShifter.outFreqs, this.shapeMorph.inFreqs2);
        connector.connect(this.pipe.outSpectrum, this.filter.inSpectrum);
        connector.connect(this.shapeMorph.outFreqs, this.filter.inShape);
        super.createDeepInternalConnections(connector, this.parts);
        this.formants.inDecayFreq.write(0.05);
    }

    @Override
    protected InputPort<?>[] getMacroInputPorts() {
        return new InputPort[]{this.pipe.inSpectrum, this.shapeShifter.inShiftRatio, this.shapeShifter.inDetune};
    }

    @Override
    protected OutputPort<?>[] getMacroOutputPorts() {
        return new OutputPort[]{this.filter.outSpectrum};
    }

    @Override
    public BounceletBase[] getParts() {
        return super.getDeepParts(this.parts);
    }
}

