/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.pitch;

import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.bouncelets.audio.base.AudioMonoSpectrumBouncelet;
import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrumPreset;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.PortValueSetter;
import org.corebounce.decklight.bouncelets.audio.ports.Presetter;
import org.corebounce.decklight.bridge.SkillType;

public class Counterpoint
extends AudioMonoSpectrumBouncelet {
    private static final float CORRECTION = (float)Math.sqrt(2.0);
    public InSpectrum inData = new InSpectrum("in", "Input audio spectrum");
    public InSpectrumPreset<Counterpoint, Preset> inPreset = new InSpectrumPreset(Preset.class, "Presets", "Predefined settings", Preset.HighCounterpoint);
    public OutSpectrum outData = new OutSpectrum("out", "Output audio spectrum");

    public Counterpoint() {
        super("audio.effect.spectrum.pitch.counterpoint", "Remove the imaginary part of the spectrum", true);
        super.setSkillType(SkillType.ADVANCED);
        this.inPreset.setSkillType(SkillType.SIMPLIFIED);
    }

    @Override
    public void process(Cmplx[] input, Cmplx[] output) {
        int i = 0;
        while (i < output.length) {
            output[i].set(input[i].re * CORRECTION, 0.0f);
            ++i;
        }
    }

    public static enum Preset implements Presetter<Counterpoint>
    {
        Rumple{

            @Override
            public void apply(Counterpoint bouncelet, PortValueSetter setter) {
                setter.setOverlap(PowerOf2.p4);
                setter.setBlockSize(PowerOf2.p2048);
            }
        }
        ,
        LowCounterpoint{

            @Override
            public void apply(Counterpoint bouncelet, PortValueSetter setter) {
                setter.setOverlap(PowerOf2.p4);
                setter.setBlockSize(PowerOf2.p512);
            }
        }
        ,
        HighCounterpoint{

            @Override
            public void apply(Counterpoint bouncelet, PortValueSetter setter) {
                setter.setOverlap(PowerOf2.p4);
                setter.setBlockSize(PowerOf2.p128);
            }
        };

    }
}

