/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.pitch;

import org.corebounce.decklight.bouncelets.audio.effect.spectrum.pitch.PhaseLockedVocoder;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;

public class Harmonizer
extends PhaseLockedVocoder {
    public InDouble inRatio1 = new InDouble("ratio1", "1st pitch shift ratio", 1.0, 0.25, 4.0);
    public InDouble inLevel1 = new InDouble("level1", "1st mix level", 0.6, 0.0, 1.0);
    public InDouble inRatio2 = new InDouble("ratio2", "2nd pitch shift ratio", 0.8, 0.25, 4.0);
    public InDouble inLevel2 = new InDouble("level2", "2nd mix level", 0.6, 0.0, 1.0);
    public InDouble inRatio3 = new InDouble("ratio3", "3rd pitch shift ratio", 1.25, 0.25, 4.0);
    public InDouble inLevel3 = new InDouble("level3", "3rd mix level", 0.6, 0.0, 1.0);
    public InDouble inRatio4 = new InDouble("ratio4", "4th pitch shift ratio", 1.0, 0.25, 4.0);
    public InDouble inLevel4 = new InDouble("level4", "4th mix level", 0.0, 0.0, 1.0);
    public InDouble inRatio5 = new InDouble("ratio5", "5th pitch shift ratio", 1.0, 0.25, 4.0);
    public InDouble inLevel5 = new InDouble("level5", "5th mix level", 0.0, 0.0, 1.0);
    public InDouble inRatio6 = new InDouble("ratio6", "6th pitch shift ratio", 1.0, 0.25, 4.0);
    public InDouble inLevel6 = new InDouble("level6", "6th mix level", 0.0, 0.0, 1.0);
    public InDouble inRatio7 = new InDouble("ratio7", "7th pitch shift ratio", 1.0, 0.25, 4.0);
    public InDouble inLevel7 = new InDouble("level7", "7th mix level", 0.0, 0.0, 1.0);
    public InDouble inRatio8 = new InDouble("ratio8", "8th pitch shift ratio", 1.0, 0.25, 4.0);
    public InDouble inLevel8 = new InDouble("level8", "8th mix level", 0.0, 0.0, 1.0);
    private InDouble[] inRatios = new InDouble[]{this.inRatio1, this.inRatio2, this.inRatio3, this.inRatio4, this.inRatio5, this.inRatio6, this.inRatio7, this.inRatio8};
    private InDouble[] inLevels = new InDouble[]{this.inLevel1, this.inLevel2, this.inLevel3, this.inLevel4, this.inLevel5, this.inLevel6, this.inLevel7, this.inLevel8};
    private final double[] ratios;
    private final float[] levels;

    public Harmonizer() {
        super("audio.effect.spectrum.pitch.harmonizer", "Pitch shift by several amounts and mix");
        super.setSkillType(SkillType.ADVANCED);
        this.ratios = new double[this.inRatios.length];
        this.levels = new float[this.inLevels.length];
        InDouble[] inDoubleArray = this.inRatios;
        int n = this.inRatios.length;
        int n2 = 0;
        while (n2 < n) {
            InDouble inRatio = inDoubleArray[n2];
            inRatio.setSkillType(SkillType.SIMPLIFIED);
            inRatio.setScaleType(ScaleType.LOG2);
            ++n2;
        }
        inDoubleArray = this.inLevels;
        n = this.inLevels.length;
        n2 = 0;
        while (n2 < n) {
            InDouble inLevel = inDoubleArray[n2];
            inLevel.setSkillType(SkillType.SIMPLIFIED);
            ++n2;
        }
    }

    @Override
    protected void setup() {
        int i = 0;
        while (i < this.inRatios.length) {
            if (this.inRatios[i].isModified()) {
                this.ratios[i] = (Double)this.inRatios[i].read();
            }
            if (this.inLevels[i].isModified()) {
                this.levels[i] = (float)((Double)this.inLevels[i].read()).doubleValue();
            }
            ++i;
        }
        super.setup();
    }

    @Override
    protected int getNumberOfResults() {
        return this.inRatios.length;
    }

    @Override
    protected double getModifiedFreq(int resultNum, double freq) {
        return freq * this.ratios[resultNum];
    }

    @Override
    protected float getModifiedLevel(int resultNum, double freq) {
        return this.levels[resultNum];
    }
}

