/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.pitch;

import org.corebounce.decklight.bouncelets.audio.effect.spectrum.pitch.PhaseLockedVocoder;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;

public class NoteScale
extends PhaseLockedVocoder {
    private static final double SQRT2 = Math.sqrt(2.0);
    public InDouble inCenterFreq = new InDouble("center", "Center note's frequency", 440.0, 330.0, 660.0);
    public InDouble inRatio = new InDouble("ratio", "Scale ratio", -1.0, -2.0, 2.0);
    private double center;
    private double ratio;

    public NoteScale() {
        super("audio.effect.spectrum.pitch.note-scale", "TODO");
        this.inCenterFreq.setSkillType(SkillType.SIMPLIFIED);
        this.inRatio.setSkillType(SkillType.SIMPLIFIED);
        this.inCenterFreq.setScaleType(ScaleType.LOG2);
    }

    @Override
    protected void setup() {
        super.setup();
        if (this.inRatio.isModified()) {
            this.ratio = (Double)this.inRatio.read();
        }
        if (this.inCenterFreq.isModified()) {
            this.center = this.hzToBin((Double)this.inCenterFreq.read());
        }
    }

    @Override
    protected double getModifiedFreq(int resultNum, double freq) {
        if (freq < 0.5) {
            return freq;
        }
        double lower = this.center / SQRT2;
        double upper = this.center * SQRT2;
        while (lower > freq) {
            lower /= 2.0;
            upper /= 2.0;
        }
        while (upper < freq) {
            lower *= 2.0;
            upper *= 2.0;
        }
        double logFreq = Math.log(freq);
        double logCenter = (Math.log(lower) + Math.log(upper)) / 2.0;
        double diff = logFreq - logCenter;
        double logResult = logCenter + diff * this.ratio;
        return Math.exp(logResult);
    }
}

