/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.pitch;

import org.corebounce.decklight.bouncelets.audio.effect.spectrum.pitch.PhaseLockedVocoder;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.ports.InDouble;

public class PitchMirror
extends PhaseLockedVocoder {
    public InDouble inCenterFreq = new InDouble("center", "Center frequency [Hz]", 440.0, 20.0, 20000.0);
    private double centerSq;
    private double minBin;
    private double maxBin;

    public PitchMirror() {
        super("audio.effect.spectrum.pitch.pitch-mirror", "Mirror frequencies");
        this.inCenterFreq.setScaleType(ScaleType.LOG2);
    }

    @Override
    protected void setup() {
        super.setup();
        if (this.inCenterFreq.isModified()) {
            this.centerSq = this.hzToBin((Double)this.inCenterFreq.read());
            this.centerSq *= this.centerSq;
            this.minBin = this.modifiedFreq(this.hzToBin(22000.0));
            this.maxBin = this.modifiedFreq(this.hzToBin(20.0));
            System.out.println("min: " + this.minBin);
            System.out.println("max: " + this.maxBin);
        }
    }

    @Override
    protected double getModifiedFreq(int resultNum, double freq) {
        if (freq < this.minBin || freq > this.maxBin) {
            return -1.0;
        }
        return this.modifiedFreq(freq);
    }

    private double modifiedFreq(double freq) {
        return this.centerSq / freq;
    }

    @Override
    protected double maxFreq() {
        double center = (Double)this.inCenterFreq.peek();
        return center * center / 20.0;
    }

    @Override
    protected double minFreq() {
        double center = (Double)this.inCenterFreq.peek();
        return center * center / 22000.0;
    }
}

