/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.pitch;

import org.corebounce.decklight.bouncelets.audio.effect.spectrum.pitch.PhaseLockedVocoder;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InBoolean;
import org.corebounce.decklight.ports.InDouble;
import org.corebounce.math.FastMath;

public class PitchScrew
extends PhaseLockedVocoder {
    public InDouble inStep = new InDouble("step", "Quantization step [Hz]", 440.0, 20.0, 1000.0);
    public InDouble inRatio = new InDouble("ratio", "Mirroring ratio", -1.0, -2.0, 2.0);
    public InDouble inShift = new InDouble("shift", "Center shift [Hz]", 0.0, -1.0, 1.0);
    public InBoolean inLogarithmic = new InBoolean("log", "Mirror using logarithmic scale", true);
    public InDouble inDryLevel = new InDouble("level.dry", "Dry (input audio) Level", 0.0, 0.0, 1.0);
    public InDouble inWetLevel = new InDouble("level.wet", "Wet (transformed audio) Level", 1.0, 0.0, 1.0);
    private double range;
    private double ratio;
    private double shift;
    private boolean log;
    private float dryLevel;
    private float wetLevel;

    public PitchScrew() {
        super("audio.effect.spectrum.pitch.pitch-screw", "Mirror frequencies around a comb");
        this.inStep.setSkillType(SkillType.SIMPLIFIED);
        this.inStep.setScaleType(ScaleType.LOG2);
        this.inRatio.setSkillType(SkillType.SIMPLIFIED);
        this.inLogarithmic.setSkillType(SkillType.ADVANCED);
    }

    @Override
    protected void setup() {
        if (this.inStep.isModified()) {
            this.range = (Double)this.inStep.read();
        }
        if (this.inShift.isModified()) {
            this.shift = (Double)this.inShift.read();
        }
        if (this.inRatio.isModified()) {
            this.ratio = (Double)this.inRatio.read();
        }
        if (this.inLogarithmic.isModified()) {
            this.log = (Boolean)this.inLogarithmic.read();
        }
        if (this.inDryLevel.isModified()) {
            this.dryLevel = (float)((Double)this.inDryLevel.read()).doubleValue();
        }
        if (this.inWetLevel.isModified()) {
            this.wetLevel = (float)((Double)this.inWetLevel.read()).doubleValue();
        }
        super.setup();
    }

    @Override
    protected int getNumberOfResults() {
        return 2;
    }

    @Override
    protected float getModifiedLevel(int resultNum, double freq) {
        if (resultNum == 0) {
            return this.dryLevel;
        }
        return this.wetLevel;
    }

    @Override
    protected double getModifiedFreq(int resultNum, double bin) {
        if (resultNum == 0) {
            return bin;
        }
        if (this.log) {
            double ceil;
            double freq = this.binToHz(bin);
            if (freq < this.range / 2.0) {
                return 0.0;
            }
            double floor = FastMath.floor((freq - this.shift * this.range) / this.range) * this.range + this.shift * this.range;
            double quantized = freq / floor > (ceil = Math.ceil((freq - this.shift * this.range) / this.range) * this.range + this.shift * this.range) / freq ? ceil : floor;
            if ((quantized = this.hzToBin(quantized)) <= 0.01) {
                return 0.0;
            }
            double logDiff = Math.log(bin / quantized);
            return quantized * Math.exp(logDiff * this.ratio);
        }
        double freq = this.binToHz(bin);
        freq = FastMath.floor((freq + this.range * 0.5 - this.shift * this.range) / this.range) * this.range + this.shift * this.range;
        double quantized = this.hzToBin(freq);
        double diff = bin - quantized;
        return quantized + diff * this.ratio;
    }
}

