/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.pitch;

import java.util.Arrays;
import org.corebounce.common.math.Cmplx;
import org.corebounce.common.math.FastMath;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.decklight.bouncelets.audio.base.SpectrumData;
import org.corebounce.decklight.bouncelets.audio.base.WindowFactory;
import org.corebounce.decklight.bouncelets.audio.base.WindowInfo;
import org.corebounce.decklight.bouncelets.audio.base.WindowType;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrumPreset;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.PortValueSetter;
import org.corebounce.decklight.bouncelets.audio.ports.Presetter;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InBoolean;
import org.corebounce.decklight.ports.InDouble;

public class PitchShiftLegacy
extends Bouncelet {
    private static final float pi = (float)Math.PI;
    public InSpectrum inSpectrum = new InSpectrum("in", "Input audio spectrum");
    public InDouble inRatio = new InDouble("ratio", "Pitch shift ratio", 1.0, 0.25, 4.0);
    public InSpectrumPreset<PitchShiftLegacy, Preset> inPreset = new InSpectrumPreset(Preset.class, "Preset", "Predefined settings", Preset.Normal);
    public InBoolean inLockInt = new InBoolean("lock", "Lock phase for integer ratios", false);
    public OutSpectrum outSpectrum = new OutSpectrum("out", "Output audio spectrum");
    private Cmplx[] source;
    private float[][] prevInAngles;
    private float[][] prevOutAngles;
    private float[] inMags;
    private float[] inFreqs;
    private float[] outMags;
    private float[] outFreqs;
    private float overlapShiftAngle;

    public PitchShiftLegacy() {
        super("audio.effect.spectrum.pitch.pitchshift-legacy", "Change the musical pitch without affecting the speed");
        super.setSkillType(SkillType.ADVANCED);
        this.inRatio.setScaleType(ScaleType.LOG2);
        this.inLockInt.setSkillType(SkillType.ADVANCED);
    }

    @Override
    public void cycle() {
        this.setup();
        this.process();
    }

    private void setup() {
        SpectrumData inData = (SpectrumData)this.inSpectrum.peek();
        boolean changes = this.outSpectrum.prepare(inData, null);
        SpectrumData outData = (SpectrumData)this.outSpectrum.get();
        if (changes |= inData.windowing.isWindowModified()) {
            this.source = Cmplx.newArray(inData.nbBins);
            float[] window = WindowFactory.getWindow(WindowType.Rectangular, outData.getNbFrames());
            outData.windowing = new WindowInfo(window, inData.windowing.getOverlapping());
            outData.windowing.setWindowModified(true);
            this.prevInAngles = new float[outData.nbChannels][outData.nbBins];
            this.prevOutAngles = new float[outData.nbChannels][outData.nbBins];
            this.inMags = new float[outData.nbBins];
            this.inFreqs = new float[outData.nbBins];
            this.outMags = new float[outData.nbBins];
            this.outFreqs = new float[outData.nbBins];
            int overlap = inData.windowing.getOverlapping().intValue();
            this.overlapShiftAngle = (float)Math.PI * -2 / (float)overlap;
            int chan = 0;
            while (chan < outData.nbChannels) {
                int i = 0;
                while (i < outData.nbBins) {
                    this.prevInAngles[chan][i] = (float)FastMath.wrap((float)i * this.overlapShiftAngle);
                    this.prevOutAngles[chan][i] = (float)FastMath.wrap((float)i * this.overlapShiftAngle);
                    ++i;
                }
                ++chan;
            }
        } else {
            outData.windowing.setWindowModified(false);
        }
        if ((this.inRatio.isModified() || this.inPreset.isModified()) && ((Boolean)this.inLockInt.read()).booleanValue()) {
            this.inPreset.read();
            double ratio = (Double)this.inRatio.read();
            if (ratio == (double)Math.round(ratio)) {
                int c = 0;
                while (c < this.prevInAngles.length) {
                    Arrays.fill(this.prevInAngles[c], 0.0f);
                    Arrays.fill(this.prevOutAngles[c], 0.0f);
                    ++c;
                }
            }
        }
    }

    private void process() {
        SpectrumData inData = (SpectrumData)this.inSpectrum.read();
        SpectrumData outData = (SpectrumData)this.outSpectrum.get();
        double ratio = (Double)this.inRatio.read();
        int overlap = inData.windowing.getOverlapping().intValue();
        inData.fillSum(this.source);
        int chan = 0;
        while (chan < inData.nbChannels) {
            this.analyze(this.source, inData.data[chan], this.prevInAngles[chan], overlap);
            this.pitchShift(ratio);
            this.synthesize(outData.data[chan], this.prevOutAngles[chan], overlap);
            ++chan;
        }
    }

    private void analyze(Cmplx[] src, Cmplx[] in, float[] lastAngles, int overlap) {
        assert (src.length == in.length);
        int i = 0;
        while (i < in.length) {
            float freq = i;
            float inAngle = src[i].phi();
            float inExpDiff = (float)FastMath.wrap((float)i * this.overlapShiftAngle);
            float inDiff = (float)FastMath.wrap(inAngle - inExpDiff - lastAngles[i]);
            inDiff = inDiff * (float)overlap / ((float)Math.PI * 2);
            this.inMags[i] = in[i].magApprox();
            this.inFreqs[i] = freq += inDiff;
            lastAngles[i] = inAngle;
            ++i;
        }
    }

    private void pitchShift(double ratio) {
        int i = 0;
        while (i < this.outMags.length) {
            this.outFreqs[i] = 0.0f;
            this.outMags[i] = 0.0f;
            ++i;
        }
        i = 0;
        while (i < this.inMags.length) {
            int k = (int)((double)i * ratio + 0.5);
            if (k > 0 && k < this.outMags.length) {
                int n = k;
                this.outMags[n] = this.outMags[n] + this.inMags[i];
                this.outFreqs[k] = this.inFreqs[i] * (float)ratio;
            }
            ++i;
        }
    }

    private void synthesize(Cmplx[] out, float[] lastAngles, int overlap) {
        int i = 0;
        while (i < out.length) {
            float outAngle;
            float mag = this.outMags[i];
            float freq = this.outFreqs[i];
            float outDiff = freq - (float)i;
            outDiff = outDiff * ((float)Math.PI * 2) / (float)overlap;
            float outExpDiff = (float)FastMath.wrap((float)i * this.overlapShiftAngle);
            lastAngles[i] = outAngle = (float)FastMath.wrap(outDiff + lastAngles[i] + outExpDiff);
            out[i].set(mag, outAngle);
            out[i].toCartesianApprox();
            ++i;
        }
    }

    public static enum Preset implements Presetter<PitchShiftLegacy>
    {
        Normal{

            @Override
            public void apply(PitchShiftLegacy bouncelet, PortValueSetter setter) {
                setter.setOverlap(PowerOf2.p4);
                setter.setSynthesisWindow(WindowType.Hann);
                setter.setPortValue(bouncelet.inLockInt, false);
            }
        }
        ,
        HighQuality{

            @Override
            public void apply(PitchShiftLegacy bouncelet, PortValueSetter setter) {
                setter.setOverlap(PowerOf2.p64);
                setter.setSynthesisWindow(WindowType.HannShrink16);
                setter.setPortValue(bouncelet.inLockInt, true);
            }
        };

    }
}

