/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.pitch;

import org.corebounce.decklight.bouncelets.audio.effect.spectrum.pitch.PhaseLockedVocoder;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;

public class PitchShiftVocoder
extends PhaseLockedVocoder {
    public InDouble inRatio = new InDouble("ratio", "Pitch shift ratio", 1.0, 0.25, 4.0);
    private double ratio;

    public PitchShiftVocoder() {
        super("audio.effect.spectrum.pitch.pitchshift-vocoder", "Change the pitch without affecting the speed");
        this.inRatio.setSkillType(SkillType.SIMPLIFIED);
        this.inRatio.setScaleType(ScaleType.LOG2);
    }

    @Override
    protected void setup() {
        if (this.inRatio.isModified()) {
            this.ratio = (Double)this.inRatio.read();
        }
        super.setup();
    }

    @Override
    protected int getNumberOfResults() {
        return 1;
    }

    @Override
    protected double getModifiedFreq(int resultNum, double freq) {
        return freq * this.ratio;
    }

    @Override
    protected double minFreq() {
        return 20.0 / this.ratio;
    }

    @Override
    protected double maxFreq() {
        return 22000.0 / this.ratio;
    }
}

