/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.shape;

import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.base.FrequenciesData;
import org.corebounce.decklight.bouncelets.audio.effect.spectrum.shape.ShapeDelayEngine;
import org.corebounce.decklight.bouncelets.audio.ports.InFrequencies;
import org.corebounce.decklight.bouncelets.audio.ports.OutFrequencies;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;

public class ShapeDelay
extends Bouncelet {
    public InFrequencies inFreqs = new InFrequencies("in", "Source shape");
    public InDouble inDelay = new InDouble("delay", "Delay [s]", 1.0, 0.01, 10.0);
    public OutFrequencies outFreqs = new OutFrequencies("out", "Delayed shape");
    private int nbBins = 0;
    private ShapeDelayEngine[] engines;

    public ShapeDelay() {
        super("audio.effect.spectrum.shape.shape-delay", "Delay the shape");
        super.setSkillType(SkillType.ADVANCED);
        this.inDelay.setScaleType(ScaleType.LOG2);
    }

    @Override
    public void cycle() {
        this.setup();
        this.process();
    }

    private int getLength(FrequenciesData data) {
        double frameDuration;
        double duration = (Double)this.inDelay.read();
        int length = (int)(duration / (frameDuration = (double)data.getNbFrames() / (double)AudioConfig.getSampleRate() / 4.0) + 0.5);
        if (length <= 0) {
            length = 1;
        }
        return length;
    }

    private void setup() {
        block3: {
            FrequenciesData data;
            block2: {
                data = (FrequenciesData)this.inFreqs.peek();
                if (this.engines != null && this.engines.length == data.nbChannels && data.nbBins == this.nbBins) break block2;
                this.nbBins = data.nbBins;
                this.engines = new ShapeDelayEngine[data.nbChannels];
                int length = this.getLength(data);
                int i = 0;
                while (i < data.nbChannels) {
                    this.engines[i] = new ShapeDelayEngine(data.nbBins, length);
                    ++i;
                }
                break block3;
            }
            if (!this.inDelay.isModified()) break block3;
            int length = this.getLength(data);
            int i = 0;
            while (i < this.engines.length) {
                this.engines[i].setSize(length);
                ++i;
            }
        }
    }

    private void process() {
        FrequenciesData inData = (FrequenciesData)this.inFreqs.read();
        this.outFreqs.prepare(inData.nbChannels, inData.nbBins);
        FrequenciesData outData = (FrequenciesData)this.outFreqs.get();
        int chan = 0;
        while (chan < inData.nbChannels) {
            this.engines[chan].push(inData.data[chan], outData.data[chan]);
            ++chan;
        }
    }
}

