/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.shape;

import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.AudioMath;
import org.corebounce.decklight.bouncelets.audio.base.FrequenciesData;
import org.corebounce.decklight.bouncelets.audio.ports.InFrequencies;
import org.corebounce.decklight.bouncelets.audio.ports.OutFrequencies;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;

public class ShapeInvert
extends Bouncelet {
    public InFrequencies inFreqs = new InFrequencies("in1", "Source shape");
    public InDouble inThreshold = new InDouble("threshold", "Maximum correction [dB]", 40.0, 0.0, 96.0);
    public OutFrequencies outFreqs = new OutFrequencies("out", "Inverted shape");
    private float minRatio;
    private float maxRatio;

    public ShapeInvert() {
        super("audio.effect.spectrum.shape.shape-invert", "Inverts the shape");
        super.setSkillType(SkillType.ADVANCED);
    }

    @Override
    public void cycle() {
        this.setup();
        this.process();
    }

    private void setup() {
        if (this.inThreshold.isModified()) {
            double threshold = (Double)this.inThreshold.read();
            this.maxRatio = (float)AudioMath.dbToLevel(threshold);
            this.minRatio = 1.0f / this.maxRatio;
        }
        FrequenciesData srcFreqs = (FrequenciesData)this.inFreqs.peek();
        this.outFreqs.prepare(srcFreqs.nbChannels, srcFreqs.nbBins);
    }

    private void process() {
        FrequenciesData srcFreqs = (FrequenciesData)this.inFreqs.read();
        FrequenciesData resFreqs = (FrequenciesData)this.outFreqs.get();
        int chan = 0;
        while (chan < srcFreqs.nbChannels) {
            float[] input = srcFreqs.data[chan];
            float[] output = resFreqs.data[chan];
            this.process(input, output);
            ++chan;
        }
    }

    private void process(float[] input, float[] output) {
        float srcPEnergy = 0.0f;
        float outPEnergy = 0.0f;
        float avgEnergy = 0.0f;
        int i = 0;
        while (i < input.length) {
            avgEnergy += input[i] * input[i];
            ++i;
        }
        avgEnergy = (float)Math.sqrt(avgEnergy) / (float)input.length;
        i = 0;
        while (i < output.length) {
            float value;
            float srcVal = input[i];
            srcPEnergy += srcVal * srcVal;
            float f = value = srcVal == 0.0f ? 0.0f : avgEnergy / srcVal;
            if (value < this.minRatio) {
                value = this.minRatio;
            } else if (value > this.maxRatio) {
                value = this.maxRatio;
            }
            output[i] = value;
            outPEnergy += value * value;
            ++i;
        }
        float correction = (float)Math.sqrt(srcPEnergy / outPEnergy);
        if (correction > this.maxRatio) {
            correction = this.maxRatio;
        }
        int i2 = 0;
        while (i2 < output.length) {
            int n = i2++;
            output[n] = output[n] * correction;
        }
    }
}

